
use  回归数据.dta,clear

*表1 描述性统计
sum2docx  YTFP UPGR GOVC WORD RDEX OPEN CLUS STFP MTFP COMU SSIV DIST RDIN  IHUM HHUM DHUM  HSTR SSTR LSTR IPAT UPAT GELE KCON using  消费升级.docx, replace stats(N  mean(%9.4f) sd(%9.4f)  max(%9.4f) min(%9.4f))

*表2 基准回归结果
use  回归数据.dta,clear
global con GOVC WORD RDEX OPEN CLUS 
asdoc reghdfe YTFP UPGR ,a(code year) vce(clu code) nest  stat(F) rep(t)  dec(4) tzok replace 
asdoc reghdfe YTFP UPGR GOVC,a(code year) vce(clu code) nest  stat(F)  dec(4) tzok append 
asdoc reghdfe YTFP UPGR GOVC WORD,a(code year) vce(clu code) nest  stat(F)  dec(4) tzok append 
asdoc reghdfe YTFP UPGR $con ,a(code year) vce(clu code) nest  stat(F)  dec(4) tzok append 

*****************************稳健性检验******************************************

*表3 稳健性检验结果
use  回归数据.dta,clear
asdoc reghdfe STFP UPGR $con,a(code year) vce(clu code) nest  stat(F) rep(t)  dec(4) tzok replace 
asdoc reghdfe MTFP UPGR $con,a(code year) vce(clu code) nest  stat(F) rep(t)  dec(4) tzok  append 
asdoc reghdfe YTFP COMU $con,a(code year) vce(clu code) nest  stat(F) rep(t)  dec(4) tzok append 
asdoc reghdfe YTFP UPGR $con if year>2012,a(code year) vce(clu code) nest stat(F)  dec(4)  tzok append 

*****************************双重差分检验******************************************
*正文图1 
use  回归数据.dta,clear
bys code year:gen t_var=(year>=2018)
gen UPGR_a=(教育文化+医疗保健+交通通信)/消费支出*100
gen UPGR_b=(教育文化+医疗保健+交通通信)/消费支出*100 if year>=2018
bys code(year):fillmissing UPGR_b,with(next)
bys code(year):fillmissing UPGR_b,with(previous)
gen did_UPGR=UPGR_b/UPGR_a
bys code(year):egen m_UPGR=mean(did_UPGR)
egen sm_UPGR=median(m_UPGR)
gen g_var=(m_UPGR<sm_UPGR)

*图1a 消费结构升级
bys year(code):egen 消费升级均值=mean(UPGR)
xtset code year
sort year
 tw (connected 消费升级均值 year,col(black) lwidth(0.2) msize(0.8)),  ///
   legend(ring(0) pos(11))  graphregion(color(white))  ///
	ylabel(,nogrid labsize(medium)) ytitle("消费结构升级均值",axis(1) size(medium))  ///
    xlabel(2006(2)2022,nogrid labsize(medium))  xtitle(" ") ///
    xline(2018, lc(black*0.5) lp(dash) )  ///
	text( 3.352 2022 "年份",size(medium)) title("(a) 消费结构升级均值趋势",  pos(6)) ///
	xsize(4) ysize(4)
   graph save 图1.gph,replace 

*图1b GTFP变动趋势
bys year(code):egen 控制组GTFP均值=mean(YTFP) if g_var==0
bys year(code):egen 处理组GTFP均值=mean(YTFP) if g_var==1
xtset code year
sort year
 tw (connected 控制组GTFP均值 year,col(black)  lwidth(0.2) msize(0.8))  ///
    (connected 处理组GTFP均值 year,col(black) lp("--")  lwidth(0.2) msize(0.8)) ,  ///
    legend(order(1 "对照组"  2 "处理组")  row(1) pos(6) size(medium))   ///
	legend(lcolor(white) region(lcolor(white))) ///
    graphregion(color(white))  ///
	ylabel(,nogrid  labsize(medium)) ytitle("{it:YTFP}均值",axis(1) size(medium))  ///
    xlabel(2006(3)2022,nogrid labsize(small))  xtitle("" ) ///
    xline(2018, lc(black*0.5) lp(dash) )  text( 6.015 2022 "年份",size(medium)) ///
	title("(b) {it:YTFP}均值趋势", pos(6)) xsize(4) ysize(4)
   graph save 图2.gph,replace
 graph combine 图1.gph 图2.gph,graphregion(color(white)) xsize(4) ysize(2)

 *表4 双重差分检验结果 第1列 DID回归
use  回归数据.dta,clear
bys code year:gen t_var=(year>=2018)
gen UPGR_a=(教育文化+医疗保健+交通通信)/消费支出*100
gen UPGR_b=(教育文化+医疗保健+交通通信)/消费支出*100 if year>=2018
bys code(year):fillmissing UPGR_b,with(next)
bys code(year):fillmissing UPGR_b,with(previous)
gen did_UPGR=UPGR_b/UPGR_a
bys code(year):egen m_UPGR=mean(did_UPGR)
egen sm_UPGR=median(m_UPGR)
gen g_var=(m_UPGR<sm_UPGR)
gen DID=g_var*t_var
asdoc reghdfe YTFP DID  $con,a(code year) clu(code) nest rep(t) stat(F) dec(4) tzok replace 

*图2 平行趋势检验和安慰剂检验
*即期
 gen period = year-2018
 gen current =(period==0 &  g_var==1)
 *处理前
 forvalues i= 12(-1)1{
 gen pre_`i' = (period == -`i' & g_var ==1) 
 }
 *处理后
 forvalues j =1(1)4{
 gen time_`j' = (period == `j'& g_var ==1)
 }
drop pre_1 
asdoc xtreg  YTFP   pre_* current  time_*  $con i.year,fe clu(code) nest stat(F) dec(4) tzok replace 

*正文图2a 平行趋势检验图
est store  YTFP_DID
coefplot YTFP_DID ,keep( pre_* current  time_* ) coeflabels(pre_12="06" pre_11="07" pre_10="08"  pre_9="09" pre_8="10" pre_7="11" pre_6="12" pre_5="13" pre_4="14" pre_3="15"  pre_2="16"  pre_1="17" current="18" time_1="19" time_2="20" time_3="21" time_4="22" )  recast(connected) color(black) yline(0,)    /// 
xline(12,lp(dash) lc(black) ) drop(_cons) ylabel(,nogrid)  ciopts(lpattern(dash) recast(rcap) msize(medium) lc(black) ) msymbol(circle_hollow) msymbol(circle_hollow)  mlstyle(solid) ///
vert nooffset  graphregion(color(white))  ///
ytitle("系数", size(*0.8))  xtitle("年份",size(*0.8) ) ///
title("图a 平行趋势检验" , size(medium) pos(12))
graph save 平行趋势检验.gph,replace

**图2b 安慰剂检验图
cap erase "ysimulations.dta"
permute DID beta = _b[DID] se = _se[DID] df = e(df_r), ///
reps(300) rseed(123) saving("ysimulations.dta"): ///
reghdfe YTFP DID $con,a(code year) vce(r) 
use "ysimulations.dta", clear
gen t_value = beta / se
gen p_value = 2 * ttail(df, abs(beta/se))

#delimit ;
dpplot beta , 
 line(lc(black))
 xline(-0.0245, lc(black*0.5) lp(dash)) mc(black) 
 xline(0, lc(black*0.5) lp(solid)) 
 xlabel(-0.03(0.005)0.03)
    xtitle("系数", size(*0.8)) xlabel(, nogrid format(%9.2f) labsize(small))
    ytitle("密度", size(*0.8)) ylabel(, nogrid format(%9.2f) labsize(small)) 
    note("") caption("")  title("图b  安慰剂检验", size(medium)) ;
#delimit cr
graph save 安慰剂检验,replace
graph combine 平行趋势检验.gph 安慰剂检验.gph ,col(2)
 

*表4 双重差分检验结果 第2、3列，模糊差分
use  回归数据.dta ,clear 
gen upgr_a=ln((教育文化+医疗保健+交通通信)/消费支出*100)
gen stock=round(upgr_a,0.001)
sort code year
by code year:egen mean_stock=mean(stock) 
by code: gen lfdmscore=mean_stock[_n-1] if code==code[_n-1] & year-1==year[_n-1]   
gen fd_gt=sign(mean_stock-lfdmscore) 
gen fd_gtx=fd_gt[_n+1] if code==code[_n+1] & year+1==year[_n+1]
set seed 123
fuzzydid YTFP fd_gt fd_gtx year stock ,tc breps(200) cluster(code) cont($con) newcateg(2.543 3.452 3.517 3.98)
set seed 123
fuzzydid STFP fd_gt fd_gtx year stock ,tc breps(200) cluster(code) cont($con) newcateg(2.543 3.485 3.495 3.98)

*****************************工具变量******************************************
*表5 工具变量检验结果
use  回归数据.dta,clear
tab year,gen(dumy)
*SSIV
asdoc xtivreg2 YTFP (UPGR=SSIV) $con dumy*,fe r first nest rep(t) stat( idstat idp cdf j jp )  dec(4) tzok replace 
*DIST
asdoc xtivreg2 YTFP (UPGR=DIST) $con dumy*,fe r first nest rep(t) stat( idstat idp cdf j jp )  dec(4) tzok append
*RDIN
asdoc xtivreg2 YTFP (UPGR=RDIN) $con dumy*,fe r first nest rep(t) stat( idstat idp cdf j jp )  dec(4) tzok append 
*三工具
asdoc xtivreg2 YTFP (UPGR=DIST RDIN  SSIV ) $con dumy*,fe r first nest rep(t) stat( idstat idp cdf j jp )  dec(4) tzok append 

*****************************传导机制******************************************
*表6 人力资本投资效应检验结果
use  回归数据.dta,clear
egen g_t=group(code year)
global var2 UPGR GOVC WORD RDEX OPEN CLUS
global var3 COMU GOVC WORD RDEX OPEN CLUS
asdoc reghdfe HHUM  $var2 ,a(code year)  vce(clu g_t) nest rep(t) stat(F) dec(4) tzok replace 
asdoc reghdfe DHUM  $var2 ,a(code year)  vce(clu g_t) nest stat(F) dec(4) tzok append 
asdoc reghdfe IHUM  $var2 ,a(code year)  vce(clu g_t) nest stat(F) dec(4) tzok append 
asdoc reghdfe IHUM  $var3,a(code year)  vce(clu g_t) nest rep(t) stat(F) dec(4) tzok append 

*表7 经济服务化效应检验结果
use  回归数据.dta,clear
egen g_t=group(code year)
asdoc reghdfe HSTR  $var2 ,a(code year)  vce(clu g_t) nest rep(t) stat(F) dec(4) tzok replace 
asdoc reghdfe SSTR  $var2 ,a(code year)  vce(clu g_t) nest stat(F) dec(4) tzok append 
asdoc reghdfe LSTR  $var2 ,a(code year)  vce(clu g_t) nest stat(F) dec(4) tzok append 
asdoc reghdfe KCON  $var2 ,a(code year)  vce(clu g_t) nest stat(F) dec(4) tzok append 
asdoc reghdfe KCON  $var3 ,a(code year)  vce(clu g_t ) nest stat(F) dec(4) tzok append 

*表8  绿色技术创新效应检验结果
use  回归数据.dta,clear
egen g_t=group(code year)
asdoc reghdfe IPAT  $var2 ,a(code year) vce(clu g_t) nest rep(t) stat(F) dec(4) tzok replace 
asdoc reghdfe UPAT  $var2 ,a(code year) vce(clu g_t) nest stat(F) dec(4) tzok append 
asdoc reghdfe GELE  $var2 ,a(code year) vce(clu g_t) nest stat(F) dec(4) tzok append 
asdoc reghdfe UPAT  $var3 ,a(code year) vce(clu g_t) nest stat(F) dec(4) tzok append 

*****************************异质性******************************************
*表9 资源禀赋异质性检验结果(一)
use  回归数据.dta,clear
egen g_t=group(code year)
*海拔高度
egen high_mean=mean(highdist)
gen high_dum=(highdist<high_mean)
asdoc reghdfe YTFP  $var2 if high_dum==1,a(code year) vce(clu g_t) nest  stat(F)  dec(4) tzok replace 
asdoc reghdfe YTFP  $var2 if high_dum==0,a(code year) vce(clu g_t) nest  stat(F)  dec(4) tzok append 
*资源型
gen 资源型=1
replace  资源型=0 if 资源型城市类型!="成熟型城市"
asdoc reghdfe YTFP  $var2 if 资源型==1,a(code year) vce(clu g_t) nest  stat(F) rep(t) dec(4) tzok append 
asdoc reghdfe YTFP  $var2 if 资源型==0,a(code year) vce(clu g_t) nest  stat(F) rep(t) dec(4) tzok append 
*消费习惯
asdoc reghdfe YTFP  $var2 if dum_save==1,a(code year) vce(clu g_t) nest  stat(F) rep(t)  dec(4) tzok append 
asdoc reghdfe YTFP  $var2 if dum_save==0,a(code year) vce(clu g_t) nest  stat(F)  rep(t) dec(4) tzok append 

*表10 内需异质性检验结果
use  回归数据.dta,clear
egen g_t=group(code year)
*社消品占GDP比重分组
asdoc reghdfe YTFP  $var2 if dum_sal==0,a(code year) vce(clu g_t) nest  rep(t)  stat(F)  dec(4) tzok replace 
asdoc reghdfe YTFP  $var2 if dum_sal==1,a(code year) vce(clu g_t) nest  stat(F)  dec(4) tzok append 

*住房财富效应
asdoc reghdfe YTFP  $var2 if dum_home==0,a(code year) vce(clu g_t) nest  stat(F)  dec(4) tzok append 
asdoc reghdfe YTFP  $var2 if dum_home==1,a(code year) vce(clu g_t) nest  stat(F)  dec(4) tzok append 

*表11 创新能力异质性检验结果

use  回归数据.dta,clear
egen g_t=group(code year)
*北大创新产业指数
asdoc reghdfe YTFP  $var2 if dum_inno==0,a(code year) vce(clu g_t) nest  stat(F) rep(t) dec(4) tzok replace 
asdoc reghdfe YTFP  $var2 if dum_inno==1,a(code year) vce(clu g_t) nest  stat(F)  dec(4) tzok append 

*城市竞争力
asdoc reghdfe YTFP  $var2 if dum_com==0,a(code year) vce(clu g_t) nest  stat(F)  dec(4) tzok append 
asdoc reghdfe YTFP  $var2 if dum_com==1,a(code year) vce(clu g_t) nest  stat(F)  dec(4) tzok append 


