clear
use "D:\桌面\研二下\经济评论\定稿\数据.dta"

global Controls1 size fa ppe
global Controls2 size fa ppe indep bm top debt 

winsor2 TFP_LP size bm top debt fa ppe indep,replace cuts(5 95)

reghdfe TFP_LP supplychainsoe $Controls1, absorb(ind year) vce(robust)
est store a1
reg TFP_LP supplychainsoe $Controls2, r
est store a2
reghdfe TFP_LP supplychainsoe $Controls2, absorb(ind year) vce(robust)
est store a3
reghdfe TFP_LP supplychainsoerate $Controls2, absorb(ind year) vce(robust)
est store a4

esttab a1 a2 a3 a4, scalar(r2_a N) compress star(* 0.1 ** 0.05 *** 0.01) b(%6.4f) t(%6.4f) mtitles title("基准回归") ,using SOE_CHAIN.rtf,replace

*系数差异性检验
reghdfe TFP_LP supplychainsoe $Controls2 if post1 == 0,absorb(ind year) vce(robust)
est store b1
reghdfe TFP_LP supplychainsoe $Controls2 if post1 == 1,absorb(ind year) vce(robust)
est store b2
gen did = supplychainsoe * post1
reg TFP_LP supplychainsoe post1 did $Controls2 ,r
est store b3
esttab b1 b2 b3, scalar(r2_a N) compress star(* 0.1 ** 0.05 *** 0.01) b(%6.4f) t(%6.4f) mtitles title("系数显著性差异检验") ,using SOE_CHAIN.rtf,append

*************
**异质性检验**
*************
*1.企业规模
sort year ind
by year ind:egen median_size = median(size)
gen guimo1 = 0 
replace guimo1 = 1 if size >= median_size
reghdfe TFP_LP supplychainsoe $Controls2 if guimo1 == 0,absorb(ind year) vce(robust)
est store d1
reghdfe TFP_LP supplychainsoe $Controls2 if guimo1 == 1,absorb(ind year) vce(robust)
est store d2
chowtest TFP_LP supplychainsoe $Controls2, group(guimo)

*2.融资约束
sort year ind
by year ind:egen median_SA = median(SA)
gen rongzi = 0 
replace rongzi = 1 if SA >= median_SA

reghdfe TFP_LP supplychainsoe $Controls2 if rongzi == 0,absorb(ind year) vce(robust)
est store d3
reghdfe TFP_LP supplychainsoe $Controls2 if rongzi == 1,absorb(ind year) vce(robust)
est store d4
chowtest TFP_LP supplychainsoe $Controls2, group(rongzi)

*3.股权性质
reghdfe TFP_LP supplychainsoe $Controls2 if state == 0,absorb(ind year) vce(robust)
est store d5
reghdfe TFP_LP supplychainsoe $Controls2 if state == 1,absorb(ind year) vce(robust)
est store d6
chowtest TFP_LP supplychainsoe $Controls2, group(state)

esttab d1 d2 d3 d4 d5 d6, scalar(r2_a N) compress star(* 0.1 ** 0.05 *** 0.01) b(%6.4f) t(%6.4f) mtitles title("异质性检验") ,using SOE_CHAIN.rtf,append

*************
**稳健性检验**
*************
*1.更换被解释变量
reghdfe TFP_OP supplychainsoe $Controls2, absorb(ind year) vce(robust)
est store e1
*2.联合固定效应
reghdfe TFP_LP supplychainsoe $Controls2, absorb(ind year city#year) vce(robust)
est store e2
*3.更改聚类层次
reghdfe TFP_LP supplychainsoe $Controls2, absorb(ind year) cluster(code)
est store e3
*4.更改样本范围
reghdfe TFP_LP supplychainsoe $Controls2 if PROVINCE != "北京市" & PROVINCE != "上海市" & PROVINCE != "天津市" & PROVINCE != "重庆市",absorb(ind year) vce(robust)
est store e4

esttab e1 e2 e3 e4 e6 e7 e8 e9, scalar(r2_a N) compress star(* 0.1 ** 0.05 *** 0.01) b(%6.4f) t(%6.4f) mtitles title("稳健性检验") ,using SOE_CHAIN.rtf,append


*5.内生性讨论
*（1）熵匹配(见代码2)
*（2）工具变量
sort ind year
by ind year:egen mean_supplychainsoe = mean(supplychainsoe)
sort code year
ivreg2 TFP_LP $Controls2 (supplychainsoe = L.mean_supplychainsoe) i.year, r
est store e6

gen iv = ln(soe_sum_2004*ave_soe_size)
winsor2 iv,replace cuts(5 95)
reg supplychainsoe iv $Controls2 , r
ivreg2 TFP_LP $Controls2 (supplychainsoe = iv),r
est store e7

*（3）反向因果
sort code year
xi: xtabond2 TFP_LP L.TFP_LP supplychainsoe $Controls2 i.year, gmm(L2.size L2.fa L2.ppe ) iv(iv L3.TFP_LP) two 
est store e8
xi: xtabond2 TFP_LP L.supplychainsoe $Controls2 i.year , gmm(L1.size L.fa L3.ppe) iv( i.code L.iv L3.TFP_LP) two 
est store e9

esttab e6 e7 e8 e9, scalar(r2_a N) compress star(* 0.1 ** 0.05 *** 0.01) b(%6.4f) t(%6.4f) mtitles title("内生性检验") ,using SOE_CHAIN.rtf,append


*************
**机制检验**
*************
*投资水平
sort code year
qui reg inv L.tq L.lev1 L.cash1 L.age L.asset L.ret L.inv i.code i.year
predict yhat,xb
gen residual = inv - yhat
gen absinv = ln(abs(residual))
drop if year<2014
sort code year

reghdfe absinv supplychainsoe $Controls2, absorb(code year) vce(robust)
est store f1

*核心创新能力
gen invpat1 = ln(发明专利申请占比)
gen invpat2 = ln(发明专利授权占比)
autofill invpat2,backward groupby(code)
reghdfe invpat1 supplychainsoe $Controls2, absorb(ind year) vce(robust)
est store f2
reghdfe invpat2 supplychainsoe $Controls2, absorb(ind year) vce(robust)
est store f3

*商品流转效率
gen turnover = ln(365/固定资产周转率A)
reghdfe turnover supplychainsoe $Controls2, absorb(ind year) vce(robust)
est store f4

esttab f1 f2 f3 f4, scalar(r2_a N) compress star(* 0.1 ** 0.05 *** 0.01) b(%6.4f) t(%6.4f) mtitles title("机制检验") ,using SOE_CHAIN.rtf,append

**************
**进一步分析**
**************
sort code year
by code: ipolate zfzr year, gen(zfzr1) 
by code: ipolate ygzr year, gen(ygzr1) 
by code: ipolate gyszr year, gen(gyszr1) 
by code: ipolate gkzr year, gen(gkzr1) 
by code: ipolate jrjgzr year, gen(jrjgzr1)
by code: ipolate shkyzr year, gen(shkyzr1)
autofill zfzr1 ygzr1 gyszr1 gkzr1 jrjgzr1 shkyzr1,backward groupby(code)

enwei zfzr1 ygzr1 gyszr1 gkzr1 jrjgzr1 shkyzr1,order(1,1,1,1,1,1)
gen score = ln(Entropy)

winsor2 score,replace cuts(5 95)
xtabond2 score L.score supplychainsoe $Controls2 i.year i.ind , gmm(L2.size fa ppe L.indep L.bm top debt) iv(i.year) two 
est store g1
xtabond2 score L.score supplychainsoe $Controls2 i.year i.ind if state == 0, gmm(L2.size fa ppe L.indep L.bm top debt) iv(i.year) two 
est store g2
xtabond2 score L.score supplychainsoe $Controls2 i.year i.ind if state == 1, gmm(L2.size fa ppe L.indep L.bm top debt) iv(i.year) two 
est store g3


*宏观经济
gen company = 1
sort year PROVINCE 
by year PROVINCE: egen pro_sum1 = sum(company)
duplicates drop PROVINCE year,force
drop if state == .
gen GDPgrowth = GDP增长率
gen realgdp = ln(真实gdp)
gen gdpperson = ln(人均地区生产总值)
gen perincome = ln(居民人均可支配收入)
gen industry = ln(第二产业增加值占GDP比重)
gen govincome = 一般公共预算收入/gdp
gen urb = 城镇化

reghdfe realgdp pro_sum1 gdpperson perincome industry govincome urb GDPgrowth,absorb(province year) vce(robust)
est store g4

esttab g1 g2 g3 g4, scalar(r2_a N) compress star(* 0.1 ** 0.05 *** 0.01) b(%6.4f) t(%6.4f) mtitles title("机制检验") ,using SOE_CHAIN.rtf,append
