use data1.dta, clear
global X lnage nature lev roe growth inde owner

**表1 变量描述性统计**
sum lnprofit lninvest datp $X
asdoc sum lnprofit lninvest datp $X, stat(N mean sd min max) dec(4) 

**表2 公共数据开放对高科技企业成长的影响**
reghdfe lnprofit datp, absorb(id year ind) cluster(provid)  
reghdfe lnprofit datp $X, absorb(id year ind) cluster(provid)  
reghdfe lninvest datp, absorb(id year ind) cluster(provid)  
reghdfe lninvest datp $X, absorb(id year ind) cluster(provid)   

**表3 排除自选择偏差与替换被解释变量结果**
//Heckman两阶段
probit policy glxl inter hlpj 
est store First
predict y_hat, xb
gen pdf = normalden(y_hat)  
gen cdf = normal(y_hat)     
gen imr = pdf/cdf           
reghdfe lnprofit datp imr $X, absorb(id year ind) cluster(provid) 
reghdfe lninvest datp imr $X, absorb(id year ind) cluster(provid)
//替换被解释变量
reghdfe size datp $X, absorb(id year ind) cluster(provid) 

**表4 控制同期相关政策检验结果**
reghdfe lnprofit datp $X bdpt, absorb(id year ind) cluster(provid)  //bdpt指大数据综合试验区
reghdfe lninvest datp $X bdpt, absorb(id year ind) cluster(provid) 
reghdfe lnprofit datp $X dtpt, absorb(id year ind) cluster(provid)  //dtpt指数据交易平台
reghdfe lninvest datp $X dtpt, absorb(id year ind) cluster(provid)  
reghdfe lnprofit datp $X szcy gzcy, absorb(id year ind) cluster(provid)  //szcy、gzcy分别指企业是否属于地区或国家重点支持产业
reghdfe lninvest datp $X szcy gzcy, absorb(id year ind) cluster(provid)  

**表5 宏观机制检验结果**
use data2.dta, clear
global contral lnpgdp indu gove lnrdp thse
//营商环境
reghdfe buem datp, absorb(provid year) cluster(provid)
reghdfe buem datp $contral, absorb(provid year) cluster(provid)  
//创新生态
reghdfe lntema datp, absorb(provid year) cluster(provid)
reghdfe lntema datp $contral, absorb(provid year) cluster(provid)  

**表6 微观机制检验**
//市场信息匹配
reghdfe rsf datp $X, absorb(id year ind) cluster(provid)
reghdfe rpc datp $X, absorb(id year ind) cluster(provid)  
reghdfe itd datp $X, absorb(id year ind) cluster(provid) 
reghdfe itr datp $X, absorb(id year ind) cluster(provid)
//开放式创新
reghdfe jap datp $X, absorb(id year ind) cluster(provid)
reghdfe jgp datp $X, absorb(id year ind) cluster(provid)
est store j2
//融资能力
reghdfe fci datp $X, absorb(id year ind) cluster(provid)  
reghdfe wwi datp $X, absorb(id year ind) cluster(provid)

**表7 外部环境与内部条件的影响**
//外部环境：数字基础设施与知识产权保护
reghdfe lnprofit datp_hdif datp $X, absorb(id year ind) cluster(provid)  
reghdfe lninvest datp_hdif datp $X, absorb(id year ind) cluster(provid)  
reghdfe lnprofit datp_hinp datp $X, absorb(id year ind) cluster(provid)
reghdfe lninvest datp_hinp datp $X, absorb(id year ind) cluster(provid)   
//内部条件：数据开放质量
reghdfe lnprofit datp $X if hdoq==1, absorb(id year ind) cluster(provid)
reghdfe lnprofit datp $X if hdoq==0, absorb(id year ind) cluster(provid)  
reghdfe lninvest datp $X if hdoq==1, absorb(id year ind) cluster(provid)
reghdfe lninvest datp $X if hdoq==0, absorb(id year ind) cluster(provid)  

**表8 公共数据开放对高科技企业技术创新的影响**
reghdfe tpa datp $X, absorb(id year ind) cluster(provid)
reghdfe nipa datp $X, absorb(id year ind) cluster(provid)  
reghdfe ipa datp $X, absorb(id year ind) cluster(provid)
reghdfe pcite datp $X, absorb(id year ind) cluster(provid)  

**附录A：附图1 处理组与控制组地区高技术产业发展水平变化**
ues data3.dta, clear
bysort year:egen tfi=mean(lnfirm) if policy==1
bysort year:egen cfi=mean(lnfirm) if policy==0
twoway (line tfi year) (line cfi year)   
save firm.gph
bysort year:egen tem=mean(lnemploy) if policy==1
bysort year:egen cem=mean(lnemploy) if policy==0
twoway (line tem year) (line cem year)
save employ.gph
bysort year:egen tin=mean(lnincome) if policy==1
bysort year:egen cin=mean(lnincome) if policy==0
twoway (line tin year) (line cin year)
save income.gph
bysort year:egen ttp=mean(lntprofit) if policy==1
bysort year:egen ctp=mean(lntprofit) if policy==0
twoway (line ttp year) (line ctp year)
save tprofit.gph
graph combine firm.gph employ.gph income.gph tprofit.gph

**附录B：附图1 事前趋势检验**
reghdfe lnprofit pre9 pre8 pre7 pre6 pre5 pre4 pre3 pre2 cur post1 post2 post3 post4 post5 post6 post7 post8 post9 $X, absorb(id year ind) cluster(provid) 
coefplot, keep(pre9 pre8 pre7 pre6 pre5 pre4 pre3 pre2 cur post1 post2 post3 post4 post5 post6 post7 post8 post9) levels(95) vertical yline(0) title("lnprofit") ytitle("系数") xtitle("公共数据开放相对时期") mcolor(black) lpattern(dash) ci
reghdfe lninvest pre9 pre8 pre7 pre6 pre5 pre4 pre3 pre2 cur post1 post2 post3 post4 post5 post6 post7 post8 post9 $X, absorb(id year ind) cluster(provid)  
coefplot, keep(pre9 pre8 pre7 pre6 pre5 pre4 pre3 pre2 cur post1 post2 post3 post4 post5 post6 post7 post8 post9) levels(95) vertical yline(0) title("lninvest") ytitle("系数") xtitle("公共数据开放相对时期") mcolor(black) lpattern(dash) ci

**附录B：附图2 安慰剂检验**
permute datp beta = _b[datp], reps(500) saving("profit_placebo.dta"): reghdfe lnprofit datp $X, absorb(id year ind) cluster(provid)  
use profit_placebo.dta
#delimit 
dpplot beta, xline(0) title("（a）lnprofit") xtitle("估计系数") ytitle("概率密度")
save profit_awj.gph
permute datp beta = _b[datp], reps(500) saving("invest_placebo.dta"): reghdfe lninvest datp $X, absorb(id year ind) cluster(provid)  
use invest_placebo.dta
#delimit 
dpplot beta, xline(0) title("（b）lninvest") xtitle("估计系数") ytitle("概率密度")
save invest_awj.gph
graph combine profit_awj.gph invest_awj.gph

**附录B：附表1 其他稳健性检验结果**
//排除样本干扰
reghdfe lnprofit datp $X if year>=2012, absorb(id year ind) cluster(provid)  
reghdfe lninvest datp $X if year>=2012, absorb(id year ind) cluster(provid) 
reghdfe lnprofit datp $X if year<=2019, absorb(id year ind) cluster(provid) 
reghdfe lninvest datp $X if year<=2019, absorb(id year ind) cluster(provid) 
//控制地区特征
reghdfe lnprofit datp $X, absorb(id year ind provid) cluster(provid)  
reghdfe lninvest datp $X, absorb(id year ind provid) cluster(provid)
//异质性处理效应
did2s lnprofit, first_stage(i.id i.ind i.year $X) second_stage(i.datp) treatment(datp) cluster(provid)
drop if lninvest==. 
did2s lninvest, first_stage(i.id i.ind i.year $X) second_stage(i.datp) treatment(datp) cluster(provid) 

**附录C：附表1 调节效应分析**
//数字创新
reghdfe lnprofit datp datp_deti deti $X, absorb(id year ind) cluster(provid)  
reghdfe lninvest datp datp_deti deti $X, absorb(id year ind) cluster(provid)
//风险管理
reghdfe lnprofit datp datp_mana mana $X, absorb(id year ind) cluster(provid)  
reghdfe lninvest datp datp_mana mana $X, absorb(id year ind) cluster(provid)

**附录C：附表2 公共数据开放对全要素生产率的赋能效应**
reghdfe lfp datp, absorb(id year ind) cluster(provid)   
reghdfe lfp datp $X, absorb(id year ind) cluster(provid) 
reghdfe ofp datp, absorb(id year ind) cluster(provid)
reghdfe ofp datp $X, absorb(id year ind) cluster(provid)
