use Data.dta, clear

global x Size Leverage Growth ROA Flow Top1 Dual GDP Pop Education

***描述性统计***
tabstat LS Market $x,s(N mean sd min p50 max) c(s) format(%9.4f)

***基准回归结果***
reghdfe LS Market,absorb(id year) vce(cluster id)
est sto m1
reghdfe LS Market $x,absorb(id year) vce(cluster id)
est sto m2
esttab m1 m2 using 基准回归结果.rtf, stat(N r2_a) cells(b(star fmt(4)) se(par fmt(4))) star(* 0.1 ** 0.05 *** 0.01) replace

***稳健性检验***
***平行趋势检验***
reghdfe LS eventz* $x,absorb(id year) vce(cluster id)
est sto m1
esttab m1 using 平行趋势检验.rtf, stat(N r2_a) cells(b(star fmt(4)) se(par fmt(4))) star(* 0.1 ** 0.05 *** 0.01) replace
***安慰剂检验***
permute Market beta = _b[Market] se = _se[Market] df = e(df_r), ///
	reps(500) seed(123) saving("simulations_LS.dta"): ///  
		reghdfe LS Market $x,absorb(id year) cluster(id) keepsingletons
use simulations_LS.dta, clear
gen t_value = beta / se
gen p_value = 2 * ttail(df, abs(beta/se))
#delimit ;
dpplot beta, 
	xline(0, lc(black*0.5) lp(dash))
	xline(0.0041, lc(black*0.5) lp(dash))
	xlabel(-0.002(0.001)0.0045)
    xtitle("估计系数", size(*1.2)) xlabel(, format(%4.3f) labsize(medium))
    ytitle("核密度", size(*1.2)) ylabel(, nogrid format(%4.0f) labsize(medium)) 
    note("") caption("") graphregion(fcolor(white)) ;
#delimit cr
***熵平衡后再回归***
reghdfe LS Market $x [aweight=_webal_3],absorb(id year) vce(cluster id)
est sto m1
esttab m1 using 熵平衡后再回归.rtf, stat(N r2_a) cells(b(star fmt(4)) se(par fmt(4))) star(* 0.1 ** 0.05 *** 0.01) replace
***替换解释变量衡量方式***
reghdfe LS_r Market $x,absorb(id year) vce(cluster id)
est sto m1
esttab m1 using 替换解释变量衡量方式.rtf, stat(N r2_a) cells(b(star fmt(4)) se(par fmt(4))) star(* 0.1 ** 0.05 *** 0.01) replace

***作用机制分析结果***
reghdfe Structure_technology Market $x,absorb(id year) vce(cluster id)
est sto m1
reghdfe Structure_education Market $x,absorb(id year) vce(cluster id)
est sto m2
reghdfe Employment Market $x,absorb(id year) vce(cluster id)
est sto m3
esttab m1 m2 m3 using 作用机制分析结果.rtf, stat(N r2_a) cells(b(star fmt(4)) se(par fmt(4))) star(* 0.1 ** 0.05 *** 0.01) replace

***异质性分析结果***
***产权性质***
reghdfe LS Market $x if Soe01==0,absorb(id year) vce(cluster id) keepsingletons
est sto m1
reghdfe LS Market $x if Soe01==1,absorb(id year) vce(cluster id) keepsingletons
est sto m2
***产品市场竞争***
reghdfe LS Market $x if Competition01==0,absorb(id year) vce(cluster id) keepsingletons
est sto m3
reghdfe LS Market $x if Competition01==1,absorb(id year) vce(cluster id) keepsingletons
est sto m4
***数字基础设施***
reghdfe LS Market $x if DI01==0,absorb(id year) vce(cluster id) keepsingletons
est sto m5
reghdfe LS Market $x if DI01==1,absorb(id year) vce(cluster id) keepsingletons
est sto m6
esttab m1 m2 m3 m4 m5 m6 using 异质性分析结果.rtf, stat(N r2_a) cells(b(star fmt(4)) se(par fmt(4))) star(* 0.1 ** 0.05 *** 0.01) replace

