clear all
clc

addpath(genpath('_func'))
addpath('data')
addpath('pdffigures')





yearlab = [1967.25:0.25:2019.75]';


p=4;

getdata2;



%% Do Morley and Wong here with Quarterly Data

 % Set up other things here
 warning('off', 'MATLAB:illConditionedMatrix');
 % Optimization options and starting value for lambda
 options.optimisation = optimset('Display','off','TolX',1e-8);  
  
 lambda0 = 1;
 lambda_MW = fminsearch(@(lambda0) BN_BVAR_oos_RMSE(y_q,p,lambda0,size(y_q,2)),0,options.optimisation);  
 qVARcycle = Morley_Wong_quarterlyBVAR(y_q,p,lambda_MW,nHF+nLF);  
 qVARcycle = percdev(qVARcycle);
  
 
 %% Do MF VAR
 
 lambda_MF = fminsearch(@(lambda0) Bayes_MF_BN_oos_RMSE(y_mf,p,lambda0,nHF,nLF,size(y_mf,2)),0,options.optimisation);  
[MF_BN_cycle,MF_growth,BVAR_obj] = Bayes_MF_BN(y_mf,p,lambda_MF,nHF,nLF,size(y_mf,2),y_mf_q1,y_mf_q2);


%% Robustness check: tv-mean for GDP growth
dy = rolling_demean(y_mf(:,end));
lambda_MF_d = fminsearch(@(lambda0) Bayes_MF_BN_oos_RMSE([y_mf(:,1:end-1) dy],p,lambda0,nHF,nLF,size(y_mf,2)),0,options.optimisation);  
[MF_BN_cycle_d,MF_growth_d,BVAR_obj_d] = Bayes_MF_BN([y_mf(:,1:end-1) dy],p,lambda_MF_d,nHF,nLF,size(y_mf,2),y_mf_q1,y_mf_q2);
  
 
%% Scenario analysis for 2020 Q2
%% This is now only used for Q3 using realized values for July
drama_factor = 5; % set zero for no scenario values
[Scenario_gap] = scenario(drama_factor,y_m,y_mf,y_mf_q1,y_m_stack,BVAR_obj,nHF,rawdata,p);



%% nowcasting Q2 and Q3
Monthly_Indicator = {'FFR (level)';'term spread';'BAA-AAA';'S&P 500 (growth)';'Consumer Sentiment';'Unemployment rate (%)';'Monthly CPI Inflation (%)';'IP growth (%)';'Housing starts growth (%)'};
maxhor = 3;


%%%% Scenario for April, May and June
sena = NaN(nHF,3);
sena(1,:) = [y_m(637,1) y_m(638,1) y_m(639,1)]; % FFR 
sena(2,:) = [y_m(636,2) y_m(636,2) y_m(636,2)]; % term spread, 636 is March 2020
sena(3,:) = [y_m(636,3) y_m(636,3) y_m(636,3)]; % risk spread
sena(4,:) = [0 0 0];                            % S&P return

for k=5:9 
 pos = k; sev_factor = 3;
 [sena(k,:) ] = response(y_m,pos,sev_factor); 
end

%% The following refers to Table 4b
%% None_Expectation
conditioned_forecast      = NaN(maxhor,nHF*3+1);
conditioned_forecast(1,:) = y_mf_q1;   % 2020 Q1
[q2q3_noinfo,April,May,June,Q3_proj] = nowc(BVAR_obj,nHF,p,y_mf,conditioned_forecast);
April(9,1)   = rawdata.m(639,9)*(1+April(9,1)/100);
May(9,1)   = April(9,1)*(1+May(9,1)/100);
June(9,1)   = May(9,1)*(1+June(9,1)/100);
nowcast_none_expectation = table(Monthly_Indicator,April,May,June);

%% None_Scenario
conditioned_forecast(2,1:3*nHF) = reshape(sena,[1,3*nHF]) ;   % April & May & June scenario
[q2q3_none_scenario,April,May,June,Q3_proj] = nowc(BVAR_obj,nHF,p,y_mf,conditioned_forecast);
April(9,1)   = rawdata.m(639,9)*(1+April(9,1)/100);
May(9,1)   = April(9,1)*(1+May(9,1)/100);
June(9,1)   = May(9,1)*(1+June(9,1)/100);
nowcast_none_scenario = table(Monthly_Indicator,April,May,June);



%% April_Expectation
conditioned_forecast      = NaN(maxhor,nHF*3+1);
conditioned_forecast(1,:) = y_mf_q1;   % 2020 Q1
conditioned_forecast(2,1:nHF) = y_mf_q2(1,1:nHF);   % April data
[q2q3_April_expectation,April,May,June,Q3_proj] = nowc(BVAR_obj,nHF,p,y_mf,conditioned_forecast);
 April(9,1) = rawdata.m(640,9);
 May(9,1)   = April(9,1)*(1+May(9,1)/100);
 June(9,1)   = May(9,1)*(1+June(9,1)/100);
nowcast_April_expectation = table(Monthly_Indicator,April,May,June);

%% April_Scenario
conditioned_forecast(2,nHF+1:3*nHF) = reshape(sena(:,2:3),[1,2*nHF]) ;
[q2q3_April_scenario,April,May,June,Q3_proj] = nowc(BVAR_obj,nHF,p,y_mf,conditioned_forecast);
April(9,1) = rawdata.m(640,9);
 May(9,1)   = April(9,1)*(1+May(9,1)/100);
 June(9,1)   = May(9,1)*(1+June(9,1)/100);
nowcast_April_scenario = table(Monthly_Indicator,April,May,June);



%% May_Expectation
conditioned_forecast      = NaN(maxhor,nHF*3+1);
conditioned_forecast(1,:) = y_mf_q1;   % 2020 Q1
conditioned_forecast(2,1:2*nHF) = y_mf_q2(1,1:2*nHF);   % April & May data
[q2q3_May_expectation,April,May,June,Q3_proj] = nowc(BVAR_obj,nHF,p,y_mf,conditioned_forecast);
April(9,1) = rawdata.m(640,9);
 May(9,1)   = rawdata.m(641,9);
 June(9,1)   = May(9,1)*(1+June(9,1)/100);
nowcast_May_expectation = table(Monthly_Indicator,April,May,June);

%% May_Scenario
conditioned_forecast(2,2*nHF+1:3*nHF) = reshape(sena(:,3),[1,nHF]) ;
[q2q3_May_scenario,April,May,June,Q3_proj] = nowc(BVAR_obj,nHF,p,y_mf,conditioned_forecast);
April(9,1) = rawdata.m(640,9);
 May(9,1)   = rawdata.m(641,9);
 June(9,1)   = May(9,1)*(1+June(9,1)/100);
nowcast_May_scenario = table(Monthly_Indicator,April,May,June);


%% June_Expectation
conditioned_forecast      = NaN(maxhor,nHF*3+1);
conditioned_forecast(1,:) = y_mf_q1;   % 2020 Q1
conditioned_forecast(2,1:3*nHF) = y_mf_q2(1,1:3*nHF);   % April & May & June data
[q2q3_June_expectation,April,May,June,Q3_proj] = nowc(BVAR_obj,nHF,p,y_mf,conditioned_forecast);

%% Final
conditioned_forecast      = NaN(maxhor,nHF*3+1);
conditioned_forecast(1,:) = y_mf_q1;   % 2020 Q1
conditioned_forecast(2,1:3*nHF)   = y_mf_q2(1,1:3*nHF);   % April & May & June data
conditioned_forecast(2,3*nHF+1)   = -9.5;
[q2q3_Final,April,May,June,Q3_proj] = nowc(BVAR_obj,nHF,p,y_mf,conditioned_forecast);



Within_quarter_information = {'None';'April';'May';'June';'Final'};
Output_gap_Expectation    =  [q2q3_noinfo(1,1); q2q3_April_expectation(1,1); q2q3_May_expectation(1,1); q2q3_June_expectation(1,1); q2q3_Final(1,1)]; 
Output_gap_Scenario       =  [q2q3_none_scenario(1,1); q2q3_April_scenario(1,1); q2q3_May_scenario(1,1); NaN; NaN]; 
Output_growth_Expectation =  [q2q3_noinfo(1,2); q2q3_April_expectation(1,2); q2q3_May_expectation(1,2); q2q3_June_expectation(1,2); q2q3_Final(1,2)]; 
Output_growth_Scenario    =  [q2q3_none_scenario(1,2); q2q3_April_scenario(1,2); q2q3_May_scenario(1,2); NaN; NaN]; 
Table4b = table(Within_quarter_information,Output_gap_Expectation,Output_gap_Scenario,Output_growth_Expectation,Output_growth_Scenario)


%% Analyse predictive power for monthly variables
recession_start = 1;    %  0: include peak quarter; 1: includes two quarters after the onset of recession
[mae] = predictpower(BVAR_obj,MF_BN_cycle,MF_growth,y_q,recession_start);


%%  Real-time analysis  
[realtime_gap ] = real_time(y_m,BVAR_obj);

%%
  load HP_data
  load CBO

 figure; fig = gcf; fig.PaperOrientation = 'landscape';
set(fig,'PaperUnits','normalized');
set(fig,'PaperPosition', [0 0 1 1]);

 h4=NBERbc(yearlab,qVARcycle(:,end),{'--'},3,{[0.93,0.69,0.13]});
hold on
 h1=plot(yearlab,MF_BN_cycle.full_information,'-b','LineWidth',3);
 hold on
 plot([yearlab(1,1) yearlab(end,1)],zeros(2,1),'-k','LineWidth',2)
 hold on
 h2 = plot(CBO_gap_yearlab,CBO_gap_vintages(:,end),'-.r','LineWidth',3);
 hold on
 h3 = plot(GDPyearlab,RT_HP_gap_vintages(:,end),':k','LineWidth',3);
 set(gca,'FontSize',14)
 legend([h1 h2 h3 h4],{'MF-BVAR','CBO Implied Output Gap','HP Filtered Output Gap','Quarterly BVAR'},'Orientation','horizontal','Location','Southeast') 

print( [ pwd '\pdffigures\image001.pdf' ] , '-dpdf' );

    
    
%%    
    
    
figure; fig = gcf; fig.PaperOrientation = 'landscape';
set(fig,'PaperUnits','normalized');
set(fig,'PaperPosition', [0 0 1 1]);
 h1=NBERbc(yearlab,realtime_gap,{'-.'},3,{'r'});
 hold on
 h2=plot(yearlab,MF_BN_cycle.full_information,'-b','LineWidth',3);
 hold on
 plot([yearlab(1,1) yearlab(end,1)],zeros(2,1),'-k','LineWidth',2)
 set(gca,'FontSize',16)
 legend([h2 h1],{'MF-BVAR Benchmark','MF-BVAR Real Time'}) 
  print( [ pwd '\pdffigures\image006.pdf' ] , '-dpdf' );
    
  
 
  
 figure; fig = gcf; fig.PaperOrientation = 'landscape';
set(fig,'PaperUnits','normalized');
set(fig,'PaperPosition', [0 0 1 1]);
 h1=NBERbc(yearlab,MF_BN_cycle_d.full_information,{'-.'},3,{'r'});
 hold on
 h2=plot(yearlab,MF_BN_cycle.full_information,'-b','LineWidth',3);
 hold on
 plot([yearlab(1,1) yearlab(end,1)],zeros(2,1),'-k','LineWidth',2)
 set(gca,'FontSize',16)
 legend([h2 h1],{'MF-BVAR Benchmark','Dynamic Demeaning'}) 
  print( [ pwd '\pdffigures\image007.pdf' ] , '-dpdf' );  
  
  
  
  %%

  
  
  figure; fig = gcf; fig.PaperOrientation = 'landscape';
set(fig,'PaperUnits','normalized');
set(fig,'PaperPosition', [0 0 1 1]);


h1=NBERbc([yearlab;2020;2020.25],[realtime_gap;2.4;Scenario_gap(end-1)],{'-'},3,{'b'});
hold on
h2=plot([yearlab;2020;2020.25],Scenario_gap(1:213),'-*b','LineWidth',3,'MarkerSize',8);
hold on
h3 = plot([2020.25;2020.5],Scenario_gap(end-1:end),':b','LineWidth',3);
hold on
h4 = plot(CBO_RT_gap(:,1),CBO_RT_gap(:,2),'-.r','LineWidth',3);
hold on
h5 = plot(CBO_gap_yearlab,CBO_gap_vintages(:,end),'-.*r','LineWidth',3,'MarkerSize',8);
hold on
h6 = plot(GDPyearlab,RT_HP_gap,':k','LineWidth',3);
hold on
h7 = plot(GDPyearlab,RT_HP_gap_vintages(:,end),':*k','LineWidth',3,'MarkerSize',8);
hold on
plot([2007 2020.75],zeros(2,1),'-k','LineWidth',2)
xlim([2007 2020.75])
ylim([-12 4])
legend([h1 h2 h3 h4 h5 h6 h7],{'MF-BVAR Real-time','MF-BVAR Ex Post','MF-BVAR Nowcast','CBO Real-time','CBO Ex Post','HP Real-time','HP Ex Post'},...
    'Location','South')
set(gca,'FontSize',14)

 print( [ pwd '\pdffigures\image007.pdf' ] , '-dpdf' );
  
  
  
  
  
  
  
  
  
  
  