

%% Get Data

load  data.mat


rawdata.m = [rawdata.m; NaN(2,9)];  % Aug & Sep 2020 


%% adjustment for consumer sentiment
 rawdata.m(1,5) = 88.3; % value of index Nov 1966
 for i=2:639            % 639 is March 2020
     if isnan(rawdata.m(i,5));
        rawdata.m(i,5) = rawdata.m(i-1,5);
     end
 end



% transform data
trans_code.q = xlsread('data_mf.xlsx','quarterly_data','j7:j7');
trans_code.m = xlsread('data_mf.xlsx','monthly_data','o16:o24');

[tLF,nLF] = size(rawdata.q);
[tHF,nHF] = size(rawdata.m);


 
%convert the monthly data into averages of quarterly data
 for jj = 1:nHF
      rawdata.m_to_q(:,jj) = mean(reshape(rawdata.m(:,jj),3,[]));
 end
 
 
 % transform monthly data
 for jj = 1:nHF
     if trans_code.m(jj) == 0
         y_m(:,jj) = rawdata.m(:,jj);
         y_m2q(:,jj) = rawdata.m_to_q(:,jj);
     elseif trans_code.m(jj) == 1
         y_m(:,jj) = [NaN;100*diff(log(rawdata.m(:,jj)))];
         y_m2q(:,jj) = [NaN;100*diff(log(rawdata.m_to_q(:,jj)))];
     elseif trans_code.m(jj) == 2
          y_m(:,jj) = [NaN;diff(rawdata.m(:,jj))];
         y_m2q(:,jj) = [NaN;diff(rawdata.m_to_q(:,jj))];
     elseif trans_code.m(jj) == 3 %log level
         y_m(:,jj) = log(rawdata.m(:,jj));
         y_m2q(:,jj) = log(rawdata.m_to_q(:,jj));
     end    
 end
 
  % transform quarterly data 
 for jj = 1:nLF
     if trans_code.q(jj) == 0
         y_q(:,jj) = rawdata.q(:,jj);
     elseif trans_code.q(jj) == 1
         y_q(:,jj) = [NaN;100*diff(log(rawdata.q(:,jj)))];
     end
 end
 
 
 
 
% Cut first quarter of observations
  y_q(1,:) = []; y_m(1:3,:) = []; y_m2q(1,:) = [];
 

 
  
 %stack the monthly observations into a form for the quarterly VAR
 y_m_stack = [y_m(1:3:end,:) y_m(2:3:end,:) y_m(3:3:end,:)];
 
 %%%%%% test
 y_mf2    = [y_m_stack(1:212,:) y_q(1:212,1)];
 y_mf_q2  = [y_m_stack(213,:) NaN];
 y_q2      = [y_m2q(1:212,:) y_q(1:212,:)];
 %%%%%%%%%
 
 
 y_mf     = [y_m_stack(1:211,:) y_q(1:211,1)];
 y_mf_q1  = [y_m_stack(212,:) y_q(212,1)];
 y_q      = [y_m2q(1:211,:) y_q(1:211,:)];

 
 y_mf2     = [y_mf;  y_mf_q1];
 y_mf3     = [y_mf2;  [y_m_stack(213,:) -9.49 ]];

 