
function [Scenario_gap ] = scenario(drama_factor,y_m,y_mf,y_mf_q1,y_m_stack,BVAR_obj,nHF,rawdata,p)

A0 = chol(BVAR_obj.SIGMA,'lower');
N = size(y_mf,2);



[unconditional_forecasts] = unconditional_forecast(BVAR_obj.A_post,BVAR_obj.y(end:-1:end-p+1,:),20);

maxhor = 3; %max ahead forecasts


conditioned_forecast = NaN(maxhor,N);

% Put in what we currently know
conditioned_forecast(1,:) = y_mf_q1;   % 2020 Q1

% Scenario forecast 2020 Q2
conditioned_forecast(2,1:nHF)         = y_m_stack(213,1:nHF);            % use data for April  
conditioned_forecast(2,nHF+1:2*nHF)   = y_m_stack(213,nHF+1:2*nHF);      % use data for May 
conditioned_forecast(2,2*nHF+1:3*nHF) = y_m_stack(213,2*nHF+1:3*nHF);    % use data for June 
conditioned_forecast(2,3*nHF+1)            = -9.5;                             % GDP growth


% Scenario forecast 2020 Q3
conditioned_forecast(3,1:8)         = y_m_stack(214,1:8);        










% This loop is to get data for the webpage
 %  drama_range = [0 ;(1:0.1:6)'];
 %  for kk = 1:size(drama_range,1)
 % drama_factor = drama_range(kk,1);

 
 %[scenario, e_diff ] = response(y_m,rawdata,drama_factor);

 
 
 %  if drama_factor > 0;
%  conditioned_forecast(2,23:33) = scenario(:,2)'; 
%  else
% % 


track_mean_for_forecast = BVAR_obj.mean_vector;

specify_conditions = conditioned_forecast;
%Demean the conditions
specify_conditions = specify_conditions - repmat(track_mean_for_forecast,maxhor,1);


[uncond_forecast_max_hor] = unconditional_forecast(BVAR_obj.A_post,BVAR_obj.y(end:-1:end-p+1,:),maxhor);
gap = specify_conditions-uncond_forecast_max_hor; %gap between conditional and unconditional forecast



[IRF] = calculate_IRF_FEVD(BVAR_obj.A_post,A0,maxhor-1);

%construct R matrix and r vector. r is the vector of reduced form forecast
%errors. R stacks the IRF to multiply by the structural shocks to give the
%conditions r

%q r and R are the notation as per Wagganor-Zha

q = 0; %number of restrictions
r = [];
R = zeros(q,maxhor*N);

for jj = 1:size(specify_conditions,1) %loop over horizon
    for ii = 1:size(specify_conditions,2)
        if isnan(specify_conditions(jj,ii)) == 0
            q = q+1; %keep track on constraints
           
            r(q,1) = gap(jj,ii);
            R(q,1:N*jj) = (reshape(fliplr(IRF(ii:N:end,1:jj)),[],1))';            
        end
    end
end

% Solving out structural shocks
fun = @(epsilon) epsilon'*epsilon;
epsilon0 = randn(maxhor*N,1);

Aeq = R;
beq = r;
epsilon = fmincon(fun,epsilon0,[],[],Aeq,beq);


%solve for reduced form shocks
for jj = 1:maxhor
    ehat(jj,:) = (A0*epsilon((jj-1)*N+1:jj*N))'; 
end


[conditional_forecasts_demeaned] = conditional_forecast(BVAR_obj.A_post,BVAR_obj.y(end:-1:end-p+1,:),ehat,maxhor);


cf = conditional_forecasts_demeaned + repmat(BVAR_obj.mean_vector,maxhor,1);



% Monthly_Indicator = {'FFR (level)';'term spread';'BAA-AAA';'S&P 500';'Consumer Sentiment';'Initial Claims';'Employment growth (000)';'Unemployment rate (%)';'Monthly CPI Inflation (%)';'IP growth (%)';'Housing starts growth (%)'};
% 
% if drama_factor > 0
% April =  cf(2,1:11)';   
% April(1,1)=0.05;
% April(6,1)= exp(April(6,1)) /1000; April(7,1)= e_diff(1,1);
% 
% May   =  cf(2,12:22)';
% May(1,1)  = 0.05;
% May(6,1)  = exp(May(6,1)) /1000;   May(7,1)  = e_diff(1,2);
% 
% 
% June  =  cf(2,23:33)'; 
% June(1,1) =0.08;  
% June(6,1) = exp(June(6,1)) /1000;
% %June(4,1) =0;   
% June(7,1)  = e_diff(1,3);
% 
% 
% else
%     April =  cf(2,1:11)'; 
%     May   =  cf(2,12:22)';
%     June  =  cf(2,23:33)';
%    
%     %FFR
%   %  April(1,1)= 0.05;
%   %  May(1,1)  = 0.05;
%     June(1,1) = 0.05 +  cf(2,23);
%    
%     
%     
%     April(6,1)= exp(April(6,1)) /1000;
%     May(6,1)  = exp(May(6,1)) /1000; 
%     June(6,1) = exp(June(6,1)) /1000;
%     
%     e_level_apr = rawdata.m(640,7); 
%     e_level_may = e_level_apr + e_level_apr*(cf(2,18)/100);
%     e_level_jun = e_level_may + e_level_may*(cf(2,29)/100);
% 
% e_diff_apr = e_level_apr - rawdata.m(639,7);
% e_diff_may = e_level_may - e_level_apr;
% e_diff_jun = e_level_jun - e_level_may;
%     
%    April(7,1)  = e_diff_apr;
%     May(7,1)   = e_diff_may;
%     June(7,1)  = e_diff_jun;
%     
% end
% 
% 
% 
% Table_3 = table(Monthly_Indicator,April,May,June)
% 
% 
% 
 f_y_mf_demean = [y_mf - repmat(BVAR_obj.mean_vector,size(y_mf,1),1);conditional_forecasts_demeaned];
 [Scenario_gap] = BN_state_space(f_y_mf_demean,zeros(1,N),p,BVAR_obj.A_post,N);
 
 Scenario_gap = percdev(Scenario_gap);
% 
% 
% %% Collect results for webpage:
% 
% %   data_all(:,kk) = [drama_factor ; April ;  May ; June ; Scenario_gap(213,1)];
% %   end
% % % 
% %   %% Collect results for webpage:
% %     date = [1967.25:0.25:2020]';
% %     filename = 'webpage.xlsx';
% %     T1   = table(data_all);
% %     T2   = table([date Scenario_gap(1:212,1)]);
% %     writetable(T1,filename,'Sheet',1,'Range','A1')
% %     writetable(T2,filename,'Sheet',2,'Range','A1')
% 
%  
%  
end




