function  [mae] = predictpower(BVAR_obj,MF_BN_cycle,MF_growth,y_q,recession_start)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%

nHF=9;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Table 1
corr_gap    = corr([MF_BN_cycle.full_information MF_BN_cycle.no_information MF_BN_cycle.monthly_update]);
corr_growth = corr([y_q(:,end)-BVAR_obj.mean_vector(1,end) MF_growth.no_information MF_growth.monthly_update]);


Within_Quarter_Information = {'None';'First month variables';'plus Second month';'plus Third month'};
Corr__Final_Estimate_gap    = corr_gap(2:5,1);
Corr__growth               = corr_growth(2:5,1);

Table_1 = table(Within_Quarter_Information,Corr__Final_Estimate_gap,Corr__growth)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Table 2

%%Tabel 3b

Information = {'None';'January';'February';'FFR (level)';'term spread';'BAA-AAA';'S&P 500 (growth)';'Consumer Sentiment';'Unemployment rate (%)';'Monthly CPI Inflation (%)';'IP growth (%)';'Housing starts growth (%)';'Final'};

Output_Gap   = [MF_BN_cycle.no_information(211,1); MF_BN_cycle.update_Q1(1,nHF);MF_BN_cycle.update_Q1(1,2*nHF:end)'; ];

Output_Growth= [MF_growth.no_information(211,1); MF_growth.Q1_update(1,nHF);MF_growth.Q1_update(1,2*nHF:end)'; ];

Table3b     = table(Information,Output_Gap,Output_Growth)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Figure 2 & 3

nHF = size(MF_BN_cycle.data_release_update,2)/3;

% full sample
mae.fullsample        =   mean(abs((repmat(MF_BN_cycle.full_information,1,nHF*3) - MF_BN_cycle.data_release_update)));
mae.fullsample_noinfo =   mean(abs(MF_BN_cycle.full_information-MF_BN_cycle.no_information ));




%%Table ??
for k=1:nHF*3

    if k==1;
e1 = MF_BN_cycle.full_information - MF_BN_cycle.no_information;
e2 = MF_BN_cycle.full_information - MF_BN_cycle.data_release_update(:,k);
    else
        
e1 = MF_BN_cycle.full_information - MF_BN_cycle.data_release_update(:,k-1);
e2 = MF_BN_cycle.full_information - MF_BN_cycle.data_release_update(:,k);
    end
        
        
[DM,p_value(1,k)] = dmtest_modified(e1, e2, 1);
end



Diebold_Mariano = {'FFR';'term spread';'BAA-AAA';'S&P 500';'Consumer Sentiment';'Unemployment';'Inflation';'IP';'Housing'};
Month1 =  p_value(1,1:nHF)';
Month2   =  p_value(1,nHF+1:2*nHF)';
Month3  =  p_value(1,2*nHF+1:3*nHF)';
Table_fullsample = table(Diebold_Mariano,Month1,Month2,Month3)





%% subsample: recession 
% Case 1: including the business cycle peak  in the quarter)

ll = 0;    % if 0: include peak quarter; if 1: includes two quarters after the onset of recession
qq = 1;
recq = [27+ll 52+ll 58+ll 94+ll 136+ll 163+ll];  % peak quarters before recession
MF_BN_cycle.full_information_re = [];
MF_BN_cycle.data_release_update_re = [];
MF_BN_cycle.no_information_re = [];


for ii=1:6  
MF_BN_cycle.full_information_re = [MF_BN_cycle.full_information_re; MF_BN_cycle.full_information(recq(1,ii):recq(1,ii)+qq)];
MF_BN_cycle.data_release_update_re = [MF_BN_cycle.data_release_update_re; MF_BN_cycle.data_release_update(recq(1,ii):recq(1,ii)+qq,:)];
MF_BN_cycle.no_information_re = [MF_BN_cycle.no_information_re; MF_BN_cycle.no_information(recq(1,ii):recq(1,ii)+qq)];
end

mae.re_0        =   mean(abs((repmat(MF_BN_cycle.full_information_re,1,nHF*3) - MF_BN_cycle.data_release_update_re)));
mae.re_noinfo_0 =   mean(abs(MF_BN_cycle.full_information_re-MF_BN_cycle.no_information_re ));


%%Table ??
for k=1:nHF*3

    if k==1;
e1 = MF_BN_cycle.full_information_re - MF_BN_cycle.no_information_re;
e2 = MF_BN_cycle.full_information_re - MF_BN_cycle.data_release_update_re(:,k);
    else
        
e1 = MF_BN_cycle.full_information_re - MF_BN_cycle.data_release_update_re(:,k-1);
e2 = MF_BN_cycle.full_information_re - MF_BN_cycle.data_release_update_re(:,k);
    end
        
        
[DM,p_value(1,k)] = dmtest_modified(e1, e2, 1);
end

Month1 =  p_value(1,1:nHF)';
Month2   =  p_value(1,nHF+1:2*nHF)';
Month3  =  p_value(1,2*nHF+1:3*nHF)';
Table_recession_case1 = table(Diebold_Mariano,Month1,Month2,Month3);













% Case 2: two quarters after the onset of a recession
ll = 1;    
qq = 1;
recq = [27+ll 52+ll 58+ll 94+ll 136+ll 163+ll];  % peak quarters before recession
MF_BN_cycle.full_information_re = [];
MF_BN_cycle.data_release_update_re = [];
MF_BN_cycle.no_information_re = [];


for ii=1:6  
MF_BN_cycle.full_information_re = [MF_BN_cycle.full_information_re; MF_BN_cycle.full_information(recq(1,ii):recq(1,ii)+qq)];
MF_BN_cycle.data_release_update_re = [MF_BN_cycle.data_release_update_re; MF_BN_cycle.data_release_update(recq(1,ii):recq(1,ii)+qq,:)];
MF_BN_cycle.no_information_re = [MF_BN_cycle.no_information_re; MF_BN_cycle.no_information(recq(1,ii):recq(1,ii)+qq)];
end

mae.re_1        =   mean(abs((repmat(MF_BN_cycle.full_information_re,1,nHF*3) - MF_BN_cycle.data_release_update_re)));
mae.re_noinfo_1 =   mean(abs(MF_BN_cycle.full_information_re-MF_BN_cycle.no_information_re ));


%%Table ??
for k=1:nHF*3

    if k==1;
e1 = MF_BN_cycle.full_information_re - MF_BN_cycle.no_information_re;
e2 = MF_BN_cycle.full_information_re - MF_BN_cycle.data_release_update_re(:,k);
    else
        
e1 = MF_BN_cycle.full_information_re - MF_BN_cycle.data_release_update_re(:,k-1);
e2 = MF_BN_cycle.full_information_re - MF_BN_cycle.data_release_update_re(:,k);
    end
        
        
[DM,p_value(1,k)] = dmtest_modified(e1, e2, 1);
end



Month1 =  p_value(1,1:nHF)';
Month2   =  p_value(1,nHF+1:2*nHF)';
Month3  =  p_value(1,2*nHF+1:3*nHF)';
Table_recession_case2 = table(Diebold_Mariano,Month1,Month2,Month3);










%% subsample: first vs second half of the sample

% subsample
mae.firsthalf         =   mean(abs((repmat(MF_BN_cycle.full_information(1:105,:),1,nHF*3) - MF_BN_cycle.data_release_update(1:105,:))));
mae.firsthalf_noinfo =   mean(abs(MF_BN_cycle.full_information(1:105,:)-MF_BN_cycle.no_information(1:105,:) ));

mae.secondhalf         =   mean(abs((repmat(MF_BN_cycle.full_information(106:end,:),1,nHF*3) - MF_BN_cycle.data_release_update(106:end,:))));
mae.secondhalf_noinfo =   mean(abs(MF_BN_cycle.full_information(106:end,:)-MF_BN_cycle.no_information(106:end,:) ));

%%Table ??
for k=1:nHF*3

    if k==1;
e1 = MF_BN_cycle.full_information(1:105,1) - MF_BN_cycle.no_information(1:105,1);
e2 = MF_BN_cycle.full_information(1:105,1) - MF_BN_cycle.data_release_update(1:105,k);
    else
        
e1 = MF_BN_cycle.full_information(1:105,1) - MF_BN_cycle.data_release_update(1:105,k-1);
e2 = MF_BN_cycle.full_information(1:105,1) - MF_BN_cycle.data_release_update(1:105,k);
    end
        
        
[DM,p_value(1,k)] = dmtest_modified(e1, e2, 1);
end


Month1 =  p_value(1,1:nHF)';
Month2   =  p_value(1,nHF+1:2*nHF)';
Month3  =  p_value(1,2*nHF+1:3*nHF)';
Table_subsample1 = table(Diebold_Mariano,Month1,Month2,Month3);



%%Table ??
for k=1:nHF*3

    if k==1;
e1 = MF_BN_cycle.full_information(106:end,1) - MF_BN_cycle.no_information(106:end,1);
e2 = MF_BN_cycle.full_information(106:end,1) - MF_BN_cycle.data_release_update(106:end,k);
    else
        
e1 = MF_BN_cycle.full_information(106:end,1) - MF_BN_cycle.data_release_update(106:end,k-1);
e2 = MF_BN_cycle.full_information(106:end,1) - MF_BN_cycle.data_release_update(106:end,k);
    end
        
        
[DM,p_value(1,k)] = dmtest_modified(e1, e2, 1);
end


Month1 =  p_value(1,1:nHF)';
Month2   =  p_value(1,nHF+1:2*nHF)';
Month3  =  p_value(1,2*nHF+1:3*nHF)';
Table_subsample2 = table(Diebold_Mariano,Month1,Month2,Month3);






colorscheme = jet();


figure; fig = gcf; fig.PaperOrientation = 'landscape';
set(fig,'PaperUnits','normalized');
set(fig,'PaperPosition', [0 0 1 1]);
x = [ 1 2 3];
vals = [ mae.fullsample(1:nHF); mae.fullsample(nHF+1:2*nHF);mae.fullsample(2*nHF+1:3*nHF)];
h = bar(x,vals); 
grid on
ylim([0 .55])
set(h, {'DisplayName'}, {'FFR','Term spread','BAA-AAA','S&P 500','Consumer Sentiment','Unemployment','Inflation','IP','Housing'}')
%Setting Color for the bars
for jj= 1:nHF
h(1,jj).FaceColor = colorscheme((jj-1)*5+1,:);
end
legend(h) 
%title('Deviation full sample')
xlabel('Month','FontName','Optima','FontSize',13);
ylabel('Mean absolute error','FontName','Optima','FontSize',12);
set(gca,'FontSize',14)

  print( [ pwd '\pdffigures\image002.pdf' ] , '-dpdf' );

%%
figure; fig = gcf; fig.PaperOrientation = 'landscape';
set(fig,'PaperUnits','normalized');
set(fig,'PaperPosition', [0 0 1 1]);
  
subplot(1,2,1)

x = [ 1 2 3];
vals = [ mae.firsthalf(1:nHF); mae.firsthalf(nHF+1:2*nHF);mae.firsthalf(2*nHF+1:3*nHF)];
h = bar(x,vals); 

grid on
ylim([0 .55])
%set(h, {'DisplayName'}, {'FFR','Term spread','BAA-AAA','S&P 500','Consumer Sentiment','Initial Claims','Employment','Unemployment','Inflation','IP','Housing'}')
%Setting Color for the bars
for jj= 1:nHF
h(1,jj).FaceColor = colorscheme((jj-1)*5+1,:);
end


%legend(h) 
title('First')
xlabel('Month','FontName','Optima','FontSize',13);
ylabel('Mean absolute error','FontName','Optima','FontSize',12);
set(gca,'FontSize',14)

subplot(1,2,2)

x = [ 1 2 3];
vals = [ mae.secondhalf(1:nHF); mae.secondhalf(nHF+1:2*nHF);mae.secondhalf(2*nHF+1:3*nHF)];
h = bar(x,vals); 

grid on
ylim([0 .55])
set(h, {'DisplayName'}, {'FFR','Term spread','BAA-AAA','S&P 500','Consumer Sentiment','Unemployment','Inflation','IP','Housing'}')

legend(h)
for jj= 1:nHF
h(1,jj).FaceColor = colorscheme((jj-1)*5+1,:);
end
title('Second')
xlabel('Month','FontName','Optima','FontSize',13);
ylabel('Mean absolute error','FontName','Optima','FontSize',12);
set(gca,'FontSize',14)

print( [ pwd '\pdffigures\image005.pdf' ] , '-dpdf' );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%










%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% figure
% subplot(3,1,1)
% x = [ 1 2 3];
% vals = [ mae.fullsample(1:nHF); mae.fullsample(nHF+1:2*nHF);mae.fullsample(2*nHF+1:3*nHF)];
% h = bar(x,vals); 
% grid on
% ylim([0 .55])
% set(h, {'DisplayName'}, {'FFR','term spread','BAA-AAA','S&P 500','Consumer Sentiment','Initial Claims','Employment','Unemployment','Inflation','IP','Housing'}')
% 
% legend(h) 
% title('Deviation full sample')
% xlabel('Month','FontName','Optima','FontSize',13);
% ylabel('Mean absolute error','FontName','Optima','FontSize',12);


figure; fig = gcf; fig.PaperOrientation = 'landscape';
set(fig,'PaperUnits','normalized');
set(fig,'PaperPosition', [0 0 1 1]);

subplot(1,2,1)
x = [ 1 2 3];
vals = [ mae.re_0(1:nHF); mae.re_0(nHF+1:2*nHF);mae.re_0(2*nHF+1:3*nHF)];
h = bar(x,vals); 

grid on
ylim([0 .55])
%set(h, {'DisplayName'}, {'FFR','Term spread','BAA-AAA','S&P 500','Consumer Sentiment','Initial Claims','Employment','Unemployment','Inflation','IP','Housing'}')
%legend(h) 
%Setting Color for the bars
for jj= 1:nHF
h(1,jj).FaceColor = colorscheme((jj-1)*5+1,:);
end
title('First 2Q of recession')
xlabel('Month','FontName','Optima','FontSize',13);
ylabel('Mean absolute error','FontName','Optima','FontSize',12);
set(gca,'FontSize',14)


subplot(1,2,2)
x = [ 1 2 3];
vals = [ mae.re_1(1:nHF); mae.re_1(nHF+1:2*nHF);mae.re_1(2*nHF+1:3*nHF)];
h = bar(x,vals); 

grid on
ylim([0 .55])
set(h, {'DisplayName'}, {'FFR','Term spread','BAA-AAA','S&P 500','Consumer Sentiment','Unemployment','Inflation','IP','Housing'}')
%Setting Color for the bars
for jj= 1:nHF
h(1,jj).FaceColor = colorscheme((jj-1)*5+1,:);
end

legend(h) 
%title('Deviation recessions Case 2')
xlabel('Month','FontName','Optima','FontSize',13);
ylabel('Mean absolute error','FontName','Optima','FontSize',12);
set(gca,'FontSize',14)
title('2Q after onset of recession')
print( [ pwd '\pdffigures\image003.pdf' ] , '-dpdf' );



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


end

