function [ pred_values,April,May,June,Q3_proj ] = nowc(BVAR_obj,nHF,p,y_mf,conditioned_forecast)


A0 = chol(BVAR_obj.SIGMA,'lower');
N = nHF*3+1;



[unconditional_forecasts] = unconditional_forecast(BVAR_obj.A_post,BVAR_obj.y(end:-1:end-p+1,:),20);

maxhor = 3; %max ahead forecasts

%conditioned_forecast      = NaN(maxhor,N);
%conditioned_forecast(1,:) = y_mf_q1;   % 2020 Q1


track_mean_for_forecast = BVAR_obj.mean_vector;

specify_conditions = conditioned_forecast;
%Demean the conditions
specify_conditions = specify_conditions - repmat(track_mean_for_forecast,maxhor,1);


[uncond_forecast_max_hor] = unconditional_forecast(BVAR_obj.A_post,BVAR_obj.y(end:-1:end-p+1,:),maxhor);
gap = specify_conditions-uncond_forecast_max_hor; %gap between conditional and unconditional forecast



[IRF] = calculate_IRF_FEVD(BVAR_obj.A_post,A0,maxhor-1);

%construct R matrix and r vector. r is the vector of reduced form forecast
%errors. R stacks the IRF to multiply by the structural shocks to give the
%conditions r

%q r and R are the notation as per Wagganor-Zha

q = 0; %number of restrictions
r = [];
R = zeros(q,maxhor*N);

for jj = 1:size(specify_conditions,1) %loop over horizon
    for ii = 1:size(specify_conditions,2)
        if isnan(specify_conditions(jj,ii)) == 0
            q = q+1; %keep track on constraints
           
            r(q,1) = gap(jj,ii);
            R(q,1:N*jj) = (reshape(fliplr(IRF(ii:N:end,1:jj)),[],1))';            
        end
    end
end

% Solving out structural shocks
fun = @(epsilon) epsilon'*epsilon;
epsilon0 = randn(maxhor*N,1);

Aeq = R;
beq = r;
epsilon = fmincon(fun,epsilon0,[],[],Aeq,beq);


%solve for reduced form shocks
for jj = 1:maxhor
    ehat(jj,:) = (A0*epsilon((jj-1)*N+1:jj*N))'; 
end


[conditional_forecasts_demeaned] = conditional_forecast(BVAR_obj.A_post,BVAR_obj.y(end:-1:end-p+1,:),ehat,maxhor);


cf = conditional_forecasts_demeaned + repmat(BVAR_obj.mean_vector,maxhor,1);
f_y_mf_demean = [y_mf - repmat(BVAR_obj.mean_vector,size(y_mf,1),1);conditional_forecasts_demeaned];
[Sc_gap] = BN_state_space(f_y_mf_demean,zeros(1,N),p,BVAR_obj.A_post,N);
Sc_gap = percdev(Sc_gap);

pred_values = [Sc_gap(213:end,1) cf(2:end,3*nHF+1)];

April  =  cf(2,1:nHF)';
May    =  cf(2,nHF+1:2*nHF)';
June   =  cf(2,2*nHF+1:3*nHF)';


%% adjust for data transformation
April(1,1) = 0.65  + April(1,1); May(1,1)   =    April(1,1) + May(1,1); June(1,1)  =    May(1,1)   + June(1,1); 




Q3_proj = zeros(9,3);











end

