function oos_RMSE = Bayes_MF_BN_oos_RMSE(y_mf,p,lambda,nHF,nLF,target_variable)
                          




% Benjamin Wong
% Monash University
% July 2019
% Companion .m file to BN_BVAR
% Takes first 20 years to train the sample before calculating the one step
% ahead out of sample root mean square error
%
%% INPUTS
%
%y                  Time series
%p                  number of lags
%lambda             Shrinkage hyper-parameter (see Banbura, Giannone and Reichlin, JAE, 2010)
%target_variable    the index (or column in y) of the target variable. Output growth in our application
%
%% OUTPUTS
%oos_RMSE                   The one step ahead pseudo out of sample forecast error

%% Preliminaries
y = y_mf;
[T N] = size(y);

for jj = 1:nHF

    mean_hf(1,jj) = mean(reshape(y_mf(:,jj:nHF:3*nHF),[],1));

end

mean_y = [repmat(mean_hf,1,3) mean(y_mf(:,3*nHF+1:end))];

%demean
y = y - repmat(mean_y,T,1);

%backcast data
y = [zeros(p,N);y];

K = p*N;        %number of parameters per equation

%% Prior on convariance matrix
Stack_AR_coeff = zeros(p,N);
covar_mat_sig2 =  zeros(N,1);
small_sig2 =  zeros(N,1);

for jj = 1:nHF
    y_m_stacked = reshape(y(:,jj:nHF:nHF*3)',[],1);
    [~,~,~,~,Xlags] = olsvar(y_m_stacked,p*3);
    
    for ii = 1:3
        coeff = inv(Xlags(1:end-ii+1,:)'*Xlags(1:end-ii+1,:))*Xlags(1:end-ii+1,:)'*y_m_stacked(12+ii:end);
        resid = y_m_stacked(12+ii:end) - Xlags(1:end-ii+1,:)*coeff;
       % covar_mat_sig2((ii-1)*nHF+jj) = (resid'*resid)/(p*3);  
        covar_mat_sig2((ii-1)*nHF+jj) = var(resid);
    end
end

small_sig2(1:3*nHF) = repmat(covar_mat_sig2(1:nHF),3,1);

for jj = nHF*3+1:N
    [~,covar_mat_sig2(jj,1),~,~,~] = olsvar(y(:,jj),p);
    small_sig2(jj) =  covar_mat_sig2(jj,1);
end
 



%Create Data Matrices
Y = y(p+1:end,:);     %Cut Away first p lags (the backcasted stuff)
X = [];

for i = 1:p
    Z = y(p+1-i:end-i,:);
    X = [X Z];
end

%% Set up matrices for variable with Signal-to-noise ratio prior


oos_resid = [];

for jj = 80:T-1
    
    
    %% Set up dummy observations
    
%     small_sig2 =  ones(N,1);
%     Stack_AR_coeff = zeros(p,N);
%     
%     for i = 1:N
%         %     calculate variance for each equation to set prior
%         %     by fitting an AR(4) per equation
%         [~,small_sig2(i,1),~,~,~] = olsvar([zeros(p,1);Y(1:jj,i)],p);
%     end
 
   Y_d = [zeros(N*p,N);
        diag(sqrt(covar_mat_sig2))];
    
    for i = 1:p
            Y_d((i-1)*N+1:i*N,:) = diag(Stack_AR_coeff(i,:)'.*repmat(i,N,1).*sqrt(small_sig2))/lambda;
    end
    
    X_d = [kron(diag(1:p),diag(sqrt(small_sig2)/lambda));
        zeros(N,K)];
   
    %% Do Least Squares to get posterior
    
    Y_star = [Y(1:jj,:);Y_d]; X_star = [X(1:jj,:); X_d];
    
    %Get VAR coefficients
    A_post = (X_star'*X_star)\(X_star'*Y_star);
    
    %One Step ahead Forecasts
    Y_F = X(jj+1,:)*A_post;
    
    oos_resid = [oos_resid;Y(jj+1,:)-Y_F];
    
end

oos_RMSE = sqrt(mean(oos_resid(:,target_variable).^2));

end