function [Scenario_gap] = BN_state_space(y,y_mean,p,A_post,target_var)
% Benjamin Wong
% Monash University
% Calculates BN decomposition by inputing all inputs
%
%y              vector(s) of variables
%p              lags
%lambda         degree of shrinkage
%nHF            number of high frequency variables (stack them in order of
%               the month, otherwise the updating does not make sense i.e. X1(M1) X2(M1)...XN(M1) X1(M2)...etc)
%nLF            number of low frequency variables
%target_var     position of the target variable to do the decomposition
%
% stack all the high frequency variables first, then low frequency ones
% later
%
% OUTPUT
% .full_information         Updates all the within quarter information
%. update_information       Updates information within the month (i.e. M1,
%                           M2, M3)
% .no_information           constructs without within month information
%

[T N] = size(y);

%demean
y = y - repmat(y_mean,T,1);

%backcast data
y = [zeros(p,N);y];
% 


%Create Data Matrices
Y = y(p+1:end,:);     %Cut Away first p lags (the backcasted stuff)
X = [];

for i = 1:p
    Z = y(p+1-i:end-i,:);
    X = [X Z];
end



%% BN Decomposition Starts here
%Add current period in to incoporate current information set to do BN decomposition
Z = X;
X = [X(2:end,:);
    Y(end,:) X(end,1:end-N)];

F = [A_post';
     eye(N*(p-1)) zeros(N*(p-1),N)];

H = [eye(N);zeros((p-1)*N,N)];        
        
bigeye = eye(N*p);

FinvIminusF = -F*((bigeye-F)\eye(N*p));
BN_cycle = FinvIminusF*X';
BN_cycle = BN_cycle(1:N,:)';

Scenario_gap = BN_cycle(:,target_var);




end

