*******************************************
***《人工智能冲击、教育扩张与工资极化————
***基于职业与地区差异的广义DID分析》
***作者：李钧宇、翟少轩、袁持平
***2025/06/14
***【实证回归命令】************************


*********【表1 描述性统计】********************************
global Xi "age gen edu hlth rgst mar pol lbu sys" //个体控制变量
global Xp "gdp pop urb ind rnd hc road gov open" //区域控制变量
su income Susc AI Eduexp $Xi

*********【表2 基准回归】**********************************
g did = Susc*AI
la var did "职业被替代概率×AI发展水平"
reghdfe income Susc AI, absorb(provcd year) cluster(provcd) //列（1）
reghdfe income did Susc AI, absorb(provcd year) cluster(provcd) //列（2）
reghdfe income Susc AI $Xi , absorb(provcd year) cluster(provcd) //列（3）
reghdfe income did Susc AI $Xi , absorb(provcd year) cluster(provcd) //列（4）
reghdfe income Susc AI $Xi $Xp , absorb(provcd year) cluster(provcd) //列（5）
reghdfe income did Susc AI $Xi $Xp , absorb(provcd year) cluster(provcd) //列（6）

*********【图1 平行趋势检验】*******************************
//根据地区专利的10分位点分组，patent_prov为取对数前的省级人工智能专利数量
g AI10 = [patent_prov<3]
g AI20 = [patent_prov>=3 & patent_prov<12]
g AI30 = [patent_prov>=12 & patent_prov<28]
g AI40 = [patent_prov>=28 & patent_prov<51]
g AI50 = [patent_prov>=51 & patent_prov<106.5]
g AI60 = [patent_prov>=106.5 & patent_prov<199]
g AI70 = [patent_prov>=199 & patent_prov<354]
g AI80 = [patent_prov>=354 & patent_prov<635]
g AI90 = [patent_prov>=635 & patent_prov<1255]
g AI100 = [patent_prov>=1255 & patent_prov!=.]
su Susc, d //确定Susc的25%和75%分位点，并分组
g Susc75=1 if Susc>=0.813 & Susc!=.
replace Susc75=0 if Susc<=0.57
la var Susc75 "prob在75%分位点以上/25%以下"
forvalues i=20(10)100{
g tr`i' = AI`i'*Susc75 //生成交互项
}
////平行趋势检验回归
reghdfe income tr20 - tr100 AI20 - AI100 Susc75 $Xi $Xp , absorb(provcd year) cluster(provcd)
est store reg
////////////画图//////////////////
coefplot, baselevels ///
xlabel(0.5 "10%" 1.5 "20%" 2.5 "30%" 3.5 "40%" 4.5 "50%" 5.5 "60%" 6.5 "70%" 7.5 "80%" 8.5 "90%" 9.5 "100%" ) ///
keep(tr*) vertical recast(connect) color(gs0) ///
yline(0, lcolor(edkblue*0.8))  ///
ylabel(,labsize(*0.75)) xlabel(,labsize(*0.75)) ///
ytitle("工资极化效应", size(small)) ///
xtitle("人工智能专利申请数分位点", size(small)) ///
addplot(line @b @at) ///
ciopts(lpattern(dash) recast(rcap) msize(medium)) ///
msymbol(circle_hollow) ///
scheme(s1mono)

*********【表3 控制遗漏变量和多种固定效应】*****************
//列（1）：加入个体认知水平控制变量
reghdfe income did Susc AI wordtest mathtest $Xi $Xp , absorb(provcd year) cluster(provcd)
//列（2）：加入外貌、智力控制变量
reghdfe income did Susc AI wordtest mathtest appearance_obs intelligence_obs $Xi $Xp , absorb(provcd year) cluster(provcd)
//列（3）：加入“地区×时间”固定效应
reghdfe income did Susc wordtest mathtest appearance_obs intelligence_obs $Xi , absorb(provyear) cluster(provcd)
//列（4）：加入职业固定效应
reghdfe income did wordtest mathtest appearance_obs intelligence_obs $Xi , absorb(provyear ISCO08) cluster(provcd)
//列（5）：加入个体固定效应
reghdfe income did wordtest mathtest appearance_obs intelligence_obs $Xi , absorb(provyear ISCO08 pid) cluster(provcd)

*********【表4 替换核心解释变量】***************************
//列（1）（2）：替换Susc
g didmax = Susc_max*AI
g didmin = Susc_min*AI
reghdfe income didmax Susc_max AI $Xi $Xp , absorb(provcd year) cluster(provcd)
reghdfe income didmin Susc_min AI $Xi $Xp , absorb(provcd year) cluster(provcd)
//列（3）：替换AI
g did_Robot = Susc*Robot
reghdfe income did_Robot Susc Robot $Xi $Xp , absorb(provcd year) cluster(provcd)

*********【表5 工具变量估计】*******************************
g IVtel_Susc = IVtel*Susc
ivreghdfe income Susc $Xi $Xp (did AI = IVtel_Susc IVtel ), absorb(provcd year) cluster(provcd)
g IVsusc_AI = IVsusc*AI
ivreghdfe income AI $Xi $Xp (did Susc = IVsusc_AI IVsusc ), absorb(provcd year) cluster(provcd)
g IVsusc_IVtel = IVsusc*IVtel
ivreghdfe income $Xi $Xp (did Susc AI = IVsusc_IVtel IVsusc IVtel ), absorb(provcd year) cluster(provcd)

*********【表6 样本选择问题处理】***************************
//列（1）（2）：Heckman模型
heckman income did Susc AI $Xi $Xp i.year i.provcd, select(Susc AI $Xi $Xp i.year i.provcd) vce(cluster provcd)
//列（3）（4）：考虑失业样本&截尾回归
g income1 = income
replace income1 = 0 if unemploy==1 & income0==0 //失业且工资为0个体在基准回归中被剔除，此处将其纳入样本
reghdfe income1 did Susc AI $Xi $Xp , absorb(provcd year) cluster(provcd)
tobit income1 did Susc AI $Xi $Xp i.year i.provcd, ll(0) cluster(provcd)

*********【表7 剔除部分样本】*******************************
xtset pid year_CFPS
sort pid year_CFPS
by pid: g job_diff = ( ISCO08 != ISCO08[_n-1] ) if _n>1
by pid: gen 职业变动 = sum( job_diff )
reghdfe income did Susc AI $Xi $Xp if 职业变动==0, absorb(provcd year) cluster(provcd)
reghdfe income did Susc AI $Xi $Xp if 第二职业!=1, absorb(provcd year) cluster(provcd)

*********【表8 滞后一期回归结果】***************************
g did_lag = Susc*AI_lag
reghdfe income did_lag Susc AI_lag , absorb(provcd year) cluster(provcd)
reghdfe income did_lag Susc AI_lag $Xi , absorb(provcd year) cluster(provcd)
reghdfe income did_lag Susc AI_lag $Xi $Xp , absorb(provcd year) cluster(provcd)

*********【表9 人工智能冲击对不同被替代概率分位点职业劳动者的影响估计】***
xtile group_x5 = Susc, nq(5) //按Susc的20%分位点分为5组
g Susc2 = (group_x5==2)
replace Susc2=. if Susc==.
g Susc3 = (group_x5==3)
replace Susc3=. if Susc==.
g Susc4 = (group_x5==4)
replace Susc4=. if Susc==.
g Susc5 = (group_x5==5)
replace Susc5=. if Susc==.
g did2 = Susc2*AI //构造交互项
g did3 = Susc3*AI
g did4 = Susc4*AI
g did5 = Susc5*AI
reghdfe income did2 - did5 Susc2 - Susc5 AI , absorb(provcd year) cluster(provcd)
reghdfe income did2 - did5 Susc2 - Susc5 AI $Xi , absorb(provcd year) cluster(provcd)
reghdfe income did2 - did5 Susc2 - Susc5 AI $Xi $Xp , absorb(provcd year) cluster(provcd)

*********【表10 人工智能冲击的替代效应机制】***************
//列（1）（2）：对工作时长影响
reghdfe worktime did Susc AI , absorb(provcd year) cluster(provcd)
reghdfe worktime did Susc AI $Xi $Xp , absorb(provcd year) cluster(provcd)
//列（3）：对工作时长满意度影响
la var time_stf "工作时间是否满意"
probit time_stf did Susc AI $Xi $Xp i.year i.provcd, cluster(provcd)
//列（4）：对失业影响
g Susc_lag_AI = Susc_lag*AI
probit unemploy Susc_lag_AI Susc_lag AI $Xi $Xp i.year i.provcd if unemploy[_n-1]==0 & _n>1, cluster(provcd)

*********【表11 人工智能冲击的生产率效应机制】*************
g income_ph = income*10000/(worktime*52) //计算小时工资
la var income_ph "每小时工资（元）"
reghdfe income_ph did Susc AI , absorb(provcd year) cluster(provcd)
reghdfe income_ph did Susc AI $Xi $Xp , absorb(provcd year) cluster(provcd)
reghdfe income_ph did Susc AI $Xi $Xp if edu>12, absorb(provcd year) cluster(provcd)
reghdfe income_ph did Susc AI $Xi $Xp  if edu<=12, absorb(provcd year) cluster(provcd)

*********【表12 人工智能冲击影响劳动者职业转换】*********
//列（1）：对职业是否发生变动的影响
probit job_diff Susc_lag_AI Susc_lag AI $Xi $Xp i.year i.provcd, cluster(provcd)
//列（2）：对职业是否朝难以被替代方向变动的影响
xtset pid year_CFPS
sort pid year_CFPS
by pid: g Susc_diff = Susc - Susc[_n-1] if _n>1
by pid: g Susc_de = (Susc_diff<0) if _n>1
probit Susc_de Susc_lag_AI Susc_lag AI $Xi $Xp i.year i.provcd, cluster(provcd)
//列（3）（4）：对职业上升和下沉的影响
by pid: g mob_up = (Susc<0.5185) if Susc[_n-1]>=0.7 & _n>1
by pid: g mob_down = (Susc<0.5701 & Susc>=0.5185) if Susc[_n-1]>=0.7 & _n>1
replace mob_up=. if Susc==.
replace mob_down=. if Susc==.
probit mob_up Susc_lag_AI Susc_lag AI $Xi $Xp i.year i.provcd, cluster(provcd)
probit mob_down Susc_lag_AI Susc_lag AI $Xi $Xp i.year i.provcd, cluster(provcd)

*********【表13 教育扩张对人工智能工资极化效应的影响】*****
//列（1）（2）：三重差分
g ddd_Eduexp = did*Eduexp
g Susc_Eduexp = Susc*Eduexp
g AI_Eduexp = AI*Eduexp
reghdfe income Susc_Eduexp did Eduexp Susc AI $Xi $Xp , absorb(provcd year) cluster(provcd)
reghdfe income ddd_Eduexp Susc_Eduexp AI_Eduexp did Eduexp Susc AI $Xi $Xp , absorb(provcd year) cluster(provcd)
//列（3）（4）：将1999年之前教育扩张水平统一为0
g Eduexp1 = Eduexp
replace Eduexp1 =0 if Gaokao_year<1999 & Gaokao_year>=1977
g ddd_Eduexp1 = did*Eduexp1
g Susc_Eduexp1 = Susc*Eduexp1
g AI_Eduexp1 = AI*Eduexp1
reghdfe income Susc_Eduexp1 did Eduexp1 Susc AI $Xi $Xp , absorb(provcd year) cluster(provcd)
reghdfe income ddd_Eduexp1 Susc_Eduexp1 AI_Eduexp1 did Eduexp1 Susc AI $Xi $Xp , absorb(provcd year) cluster(provcd)

*********【表14 不同教育供给水平下人工智能工资极化效应各路径的表现】*****
reghdfe worktime did Susc AI $Xi $Xp if Eduexp>=1.2368 & Eduexp!=., absorb(provcd year) cluster(provcd)
reghdfe worktime did Susc AI $Xi $Xp if Eduexp<1.2368, absorb(provcd year) cluster(provcd)
reghdfe income_ph did Susc AI $Xi $Xp if Eduexp>=1.2368 & Eduexp!=., absorb(provcd year) cluster(provcd)
reghdfe income_ph did Susc AI $Xi $Xp if Eduexp<1.2368, absorb(provcd year) cluster(provcd)
probit Susc_de Susc_lag_AI Susc_lag AI $Xi $Xp i.year i.provcd if Eduexp>=1.2368 & Eduexp!=., cluster(provcd)
probit Susc_de Susc_lag_AI Susc_lag AI $Xi $Xp i.year i.provcd if Eduexp<1.2368, cluster(provcd)

*********【图2 Susc×Eduexp系数随高等教育劳动者占比变化趋势】***
vc_bw income Susc_Eduexp did Eduexp Susc AI $Xi $Xp i.year i.provcd if age>22, vcoeff(HighEdu_bar)
vc_reg income Susc_Eduexp did Eduexp Susc AI $Xi $Xp i.year i.provcd if age>22, vcoeff(HighEdu_bar) bw(0.16612) klist(0(.0264)0.66) cluster(provcd)
vc_graph Susc_Eduexp

*********【图3 Susc×AI×Eduexp系数随高等教育劳动者占比变化趋势】***
vc_bw income ddd_Eduexp Susc_Eduexp AI_Eduexp did Eduexp Susc AI $Xi $Xp i.year i.provcd if age>22, vcoeff(HighEdu_bar)
vc_reg income ddd_Eduexp Susc_Eduexp AI_Eduexp did Eduexp Susc AI $Xi $Xp i.year i.provcd if age>22,vcoeff(HighEdu_bar) bw(0.16814) klist(0(.0264)0.66) cluster(provcd)
vc_graph ddd_Eduexp

