use "C:\Users\admin\Desktop\财富与生育实证\new回归数据.dta", clear

****描述性统计
asdoc sum childnum CHD1 expchaiqian edu_p gender liv_area emp health trust  edu_fm famsize perhou_income expen tot_assets exp_childedu mater_ins pGDP [aweight=rswt_natpn1012] if chaiqian14==1

asdoc sum childnum CHD1 expchaiqian edu_p gender liv_area emp health trust  edu_fm famsize perhou_income expen tot_assets exp_childedu mater_ins pGDP [aweight=rswt_natpn1012] if chaiqian14==0

**DID设置
gen time=(year>=2014)&!missing(year)
gen treat12=(chaiqian14>0)&!missing(chaiqian14)
gen did11=time*treat12

gen time=(year>=2014)&!missing(year)
gen treat22=(expchaiqian==1)&!missing(expchaiqian)
gen expcq1=time*treat22

gen did13=CHD1*time

**倾向得分匹配
psmatch2 treat12 expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & agesy==1 , out(childnum) logit ties ate neighbor(4) common
pstest expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & agesy==1 , both graph

global control6 i.edu_p gender liv_area emp i.health trust i.edu_fm famsize perhou_income expen tot_assets exp_childedu mater_ins pGDP

global did11 did11
global did13 did13
global expcq1 expcq1

***1.基准回归
reghdfe childnum did11 expcq1 $control6 [pweight=rswt_natpn1012],absorb(fid14 year) cluster(fid14) 
est store m1
reghdfe childnum did11 $control6  [pweight=rswt_natpn1012] if _support==1,absorb(fid14 year) cluster(fid14) 
est store m2
reghdfe childnum did13 expcq1 $control6 [pweight=rswt_natpn1012] ,absorb(fid14 year) cluster(fid14)
est store l1
reghdfe childnum did13 $control6  [pweight=rswt_natpn1012] if _support==1 ,absorb(fid14 year) cluster(fid14)
est store l2
esttab m1 m2 l1 l2, mtitle(`mt')  b(%6.3f) se(%10.3f) nogap compress  ///
order($did11 $did13 $expcq1 ) ///
star(* 0.1 ** 0.05 *** 0.01)  ar2 replace

***2.异质性分析
//孩子数量与孩子性别
reghdfe childnum did11 $control6 [pweight=rswt_natpn1012] if _support==1 & classify_childnum12==0 | classify_childnum12==1 ,absorb(fid14 year) cluster(fid14)
est store c1
reghdfe childnum did11 $control6 [pweight=rswt_natpn1012] if _support==1 & classify_childnum12>=2 ,absorb(fid14 year) cluster(fid14) 
est store c2
reghdfe childnum did11 $control6 [pweight=rswt_natpn1012] if _support==1 &  boynum==0 ,absorb(fid14 year) cluster(fid14)
est store c3
reghdfe childnum did11 $control6 [pweight=rswt_natpn1012]  if _support==1 & boynum>0 ,absorb(fid14 year) cluster(fid14)
est store c4
esttab c1 c2 c3 c4 , mtitle(`mt')  b(%6.3f) se(%10.3f) nogap compress  ///
order($did11  $did11 ) ///
keep($did11  $did11 ) ///
star(* 0.1 ** 0.05 *** 0.01)   ar2 replace

//生活满意度与社会地位
reghdfe childnum did11 $control6 [pweight=rswt_natpn1012] if _support==1 & satisfy==1 ,absorb(fid14 year) cluster(fid14) 
est store d1
reghdfe childnum did11 $control6 [pweight=rswt_natpn1012] if _support==1 & satisfy==2 ,absorb(fid14 year) cluster(fid14) 
est store d2
reghdfe childnum did11 $control6 [pweight=rswt_natpn1012] if _support==1 &  satisfy==3 ,absorb(fid14 year) cluster(fid14) 
est store d3
reghdfe childnum did11 $control6 [pweight=rswt_natpn1012] if _support==1 & social_status==1 ,absorb(fid14 year) cluster(fid14) 
est store d4
reghdfe childnum did11 $control6 [pweight=rswt_natpn1012] if _support==1 & social_status==2 ,absorb(fid14 year) cluster(fid14) 
est store d5
reghdfe childnum did11 $control6 [pweight=rswt_natpn1012] if _support==1 & social_status==3 ,absorb(fid14 year) cluster(fid14) 
est store d6
esttab d1 d2 d3 d4 d5 d6, mtitle(`mt')  b(%6.3f) se(%10.3f) nogap compress  ///
order($did11  $did11 ) ///
keep($did11  $did11 ) ///
star(* 0.1 ** 0.05 *** 0.01)  ar2 replace
**# Bookmark #6

***3.机制分析
//养育能力强化
reghdfe supportability did11 expcq1 $control6 [pweight=rswt_natpn1012],absorb(fid14 year)  cluster(fid14)
est store l2
esttab l2 , mtitle(`mt')  b(%6.3f) se(%10.3f) nogap compress  ///
order($did11  $did11 ) ///
keep($did11  $did11 ) ///
star(* 0.1 ** 0.05 *** 0.01) ar2 replace
//生育意愿提升（多期DID14-20）
use "C:\Users\admin\Desktop\财富与生育实证\new多期稳健性检验111.dta", clear

global did2016 did2016
global control6 i.edu_p gender liv_area emp i.health trust i.edu_fm famsize perhou_income expen tot_assets exp_childedu mater_ins pGDP

gen treat16=0 
drop if 房屋拆迁14==1 
replace treat16=1 if 有无房屋拆迁16==1 
replace treat16=1 if 有无房屋拆迁18==1 
replace treat16=1 if 有无房屋拆迁20==1
gen time16=9988
replace time16=2020 if 有无房屋拆迁20==1
replace time16=2018 if 有无房屋拆迁18==1
replace time16=2016 if 有无房屋拆迁16==1
gen t2016=0 
replace t2016=1 if year>=time16
gen did2016=treat16*t2016

reghdfe ideal_childnum did2016 $control6 if agesy==1 & year>2012 & year<2020 [pweight=rswt_natpn1018], absorb(fid14 year) cluster(fid14)
est store l3
esttab l3 , mtitle(`mt')  b(%6.3f) se(%10.3f) nogap compress  ///
order($did2016  $did2016 ) ///
keep($did2016  $did2016 ) ///
star(* 0.1 ** 0.05 *** 0.01) ar2 replace


***安慰剂检验
use "C:\Users\admin\Desktop\财富与生育实证\new回归数据.dta", clear
ssc install dpplot
cap erase "simulations.dta"
permute did1 beta=_b[did1] se=_se[did] df=e(df_r), reps(1000) rseed(123) saving("simulations.dta"):reghdfe childnum did11 $control6 [pweight=rswt_natpn1012], absorb(fid14 year) cluster(fid14)
use "simulations.dta",clear
g t_value=beta/se
g p_value=2*ttail(df, abs(beta/se))
dpplot beta, xline(0.111, lc(black*0.5) lp(dash)) xtitle("Estimator") ytitle("Density")
dpplot t_value, xtitle("T-value") ytitle("核密度")
dpplot p_value, xtitle("P-value") ytitle("核密度")
twoway(scatter p_value beta) (kdensity beta, yaxis(2))

***稳健性检验
//1.多时点DID
****（多期DID12-20）
use "C:\Users\admin\Desktop\财富与生育实证\new多期稳健性检验111.dta", clear
gen 多期treat=0 
replace 多期treat=1 if 房屋拆迁14==1 
replace 多期treat=1 if 有无房屋拆迁16==1 
replace 多期treat=1 if 有无房屋拆迁18==1 
replace 多期treat=1 if 有无房屋拆迁20==1 
gen 多期time=6666
replace 多期time=2020 if 有无房屋拆迁20==1
replace 多期time=2018 if 有无房屋拆迁18==1
replace 多期time=2016 if 有无房屋拆迁16==1
replace 多期time=2014 if 房屋拆迁14==1
gen 多期t=0 
replace 多期t=1 if year>=多期time
gen 多期did=多期treat*多期t

global control6 i.edu_p gender liv_area emp i.health trust i.edu_fm famsize perhou_income expen tot_assets exp_childedu mater_ins pGDP

psmatch2 多期treat expen perhou_income tot_assets gender liv_area i.edu_p famsize i.edu_fm mater_ins pGDP if agesy==1, out(childnum) logit ties ate neighbor(4) common
pstest expen perhou_income tot_assets gender liv_area i.edu_p famsize i.edu_fm mater_ins pGDP if agesy==1, both graph
reghdfe childnum 多期did $control6 if agesy==1 [pweight=rswt_natpn1012] , absorb(fid14 year) cluster(fid14)
reghdfe childnum 多期did $control6 if agesy==1 & _support==1 [pweight=rswt_natpn1012] , absorb(fid14 year) cluster(fid14)
****（多期DID14-20）
use "C:\Users\admin\Desktop\财富与生育实证\new多期稳健性检验111.dta", clear
gen treat16=0 
drop if 房屋拆迁14==1 
replace treat16=1 if 有无房屋拆迁16==1 
replace treat16=1 if 有无房屋拆迁18==1 
replace treat16=1 if 有无房屋拆迁20==1
gen time16=9988
replace time16=2020 if 有无房屋拆迁20==1
replace time16=2018 if 有无房屋拆迁18==1
replace time16=2016 if 有无房屋拆迁16==1
gen t2016=0 
replace t2016=1 if year>=time16
gen did2016=treat16*t2016

psmatch2 treat16 expen perhou_income tot_assets gender liv_area i.edu_p famsize i.edu_fm mater_ins pGDP if agesy==1, out(childnum) logit ties ate neighbor(4) common
pstest expen perhou_income tot_assets gender liv_area i.edu_p famsize i.edu_fm mater_ins pGDP if agesy==1, both graph

reghdfe childnum did2016 $control6 if agesy==1 [pweight=rswt_natpn1012], absorb(fid14 year) cluster(fid14)
reghdfe childnum did2016 $control6 if agesy==1  & _support==1 [pweight=rswt_natpn1012], absorb(fid14 year) cluster(fid14)

****（多期DID16-20）
use "C:\Users\admin\Desktop\财富与生育实证\new多期稳健性检验111.dta", clear
gen treat18=0 
drop if 房屋拆迁14==1 
drop if 有无房屋拆迁16==1 
replace treat18=1 if 有无房屋拆迁18==1 
replace treat18=1 if 有无房屋拆迁20==1
gen time18=9999
replace time18=2020 if 有无房屋拆迁20==1
replace time18=2018 if 有无房屋拆迁18==1
gen t2018=0 
replace t2018=1 if year>=time18
gen did2018=treat18*t2018

psmatch2 treat18 expen perhou_income tot_assets gender liv_area i.edu_p famsize i.edu_fm mater_ins pGDP if agesy==1, out(childnum) logit ties ate neighbor(5) common
pstest expen perhou_income tot_assets gender liv_area i.edu_p famsize i.edu_fm mater_ins pGDP if agesy==1, both graph

reghdfe childnum did2018 $control6 if agesy==1 [pweight=rswt_natpn1012], absorb(fid16 year) cluster(fid16)
reghdfe childnum did2018 $control6 if agesy==1 & _support==1  [pweight=rswt_natpn1012], absorb(fid16 year) cluster(fid16)

//2.更换倾向得分匹配方式
use "C:\Users\admin\Desktop\财富与生育实证\new回归数据.dta", clear
****(1)近邻匹配--1:3（原始1:4）
psmatch2 treat12 expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & agesy==1 , out(childnum) logit ties ate neighbor(3) common
pstest expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & agesy==1 , both graph

reghdfe childnum did11 $control6 if same_prov==1 & same_county==1 & agesy==1 & _support==1  [pweight=rswt_natpn1012], absorb(fid14 year) cluster(fid14)

****(2)半径匹配（0.01）
psmatch2 treat12 expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & agesy==1 , out(childnum) logit ties ate  radius cal(0.01) common
pstest expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & agesy==1 , both graph

reghdfe childnum did11 $control6 if same_prov==1 & same_county==1 & agesy==1 & _support==1  [pweight=rswt_natpn1012], absorb(fid14 year) cluster(fid14)

****(3)半径匹配（0.05）
psmatch2 treat12 expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & agesy==1 , out(childnum) logit ties ate  radius cal(0.05) common
pstest expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & agesy==1 , both graph

reghdfe childnum did11 $control6 if same_prov==1 & same_county==1 & agesy==1 & _support==1  [pweight=rswt_natpn1012], absorb(fid14 year) cluster(fid14)

****(4)核匹配
psmatch2 treat12 expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & agesy==1 , out(childnum) logit ties ate kernel common
pstest expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & agesy==1 , both graph

reghdfe childnum did11 $control6 if same_prov==1 & same_county==1 & agesy==1 & _support==1  [pweight=rswt_natpn1012], absorb(fid14 year) cluster(fid14)

//3.调整聚类方式
use "C:\Users\admin\Desktop\财富与生育实证\new回归数据.dta", clear
reghdfe childnum did11 $control6 if _support==1 [pweight=rswt_natpn1012],absorb(fid14 year) cluster(村居编码) 
est store m1
reghdfe childnum did11 $control6 if _support==1 [pweight=rswt_natpn1012],absorb(fid14 year) cluster(区县编码) 
est store m2
esttab m1 m2, mtitle(`mt')  b(%6.3f) se(%10.3f) nogap compress  ///
order($did11  $did11 ) ///
keep($did11  $did11 ) ///
star(* 0.1 ** 0.05 *** 0.01)   ar2 replace

//4.psm作为控制变量引入回归
psmatch2 treat12 expchaqian expen perhou_income tot_assets gender liv_area i.edu_p famsize i.edu_fm mater_ins pGD if same_prov==1 & same_county==1 & agesy==1, out(childnum) logit ties ate neighbor(4) common
gen kzbl=time* _pscore
reghdfe childnum did11 expcq1 kzbl $control6 if same_prov==1 & same_county==1 & agesy==1 & _support==1 [pweight=rswt_natpn1012], absorb(fid14 year) cluster(fid14)
//5.调整样本
****（1）剔除直辖市
*删除北京11、上海31、天津12、重庆50直辖市
use "C:\Users\admin\Desktop\财富与生育实证\new回归数据.dta", clear
drop if 省编码==11 | 省编码==31 | 省编码==50 | 省编码==12 
reghdfe childnum did11 $control6 if _support==1 [pweight=rswt_natpn1012],absorb(fid14 year) cluster(fid14) 
est store m3
esttab m3 , mtitle(`mt')  b(%6.3f) se(%10.3f) nogap compress  ///
order($did11  $did11 ) ///
keep($did11  $did11 ) ///
star(* 0.1 ** 0.05 *** 0.01)   ar2 replace
****（2）保留法定结婚年龄及以上
use "C:\Users\admin\Desktop\财富与生育实证\new回归数据.dta", clear
psmatch2 treat12 expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & age>=20, out(childnum) logit ties ate neighbor(4) common
pstest expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & age>=20 , both graph
reghdfe childnum did11 $control6 if same_prov==1 & same_county==1 & age>=20 & _support==1 [pweight=rswt_natpn1012], absorb(fid14 year) cluster(fid14)
****（3）保留16—49岁年龄段
use "C:\Users\admin\Desktop\财富与生育实证\new回归数据.dta", clear
psmatch2 treat12 expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & age>=16, out(childnum) logit ties ate neighbor(4) common
pstest expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & age>=16, both graph
reghdfe childnum did11 $control6 if same_prov==1 & same_county==1 & age>=16 & _support==1 [pweight=rswt_natpn1012], absorb(fid14 year) cluster(fid14)
****（4）限制女性15—44岁年龄段
use "C:\Users\admin\Desktop\财富与生育实证\new回归数据.dta", clear
gen 女性1544年龄=1 if age<=44 & gender==0
replace 女性1544年龄=1 if gender==1
gen 仅女性1544年龄=1 if age<=44 & gender==0
psmatch2 treat12 expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & 女性1544年龄==1 , out(childnum) logit ties ate neighbor(4) common
pstest expchaqian expen perhou_income tot_assets gender liv_area edu_p famsize i.edu_fm mater_ins pGDP if same_prov==1 & same_county==1 & 女性1544年龄==1 , both graph
reghdfe childnum did11 $control6 if same_prov==1 & same_county==1 & 女性1544年龄==1 & _support==1 [pweight=rswt_natpn1012], absorb(fid14 year) cluster(fid14)

//6.排除其他政策和疫情干扰
****（1）排除疫情干扰
use "C:\Users\admin\Desktop\财富与生育实证\new回归数据.dta", clear
drop if year==2020
reghdfe childnum did11 $control6 if same_prov==1 & same_county==1 & agesy==1 &_support==1 [pweight=rswt_natpn1012] ,absorb(fid14 year) cluster(fid14) 
est store m2
esttab m2 , mtitle(`mt')  b(%6.3f) se(%10.3f) nogap compress  ///
keep($did11 $did11 ) ///
order($did11 $did11 ) ///
star(* 0.1 ** 0.05 *** 0.01)  ar2 replace
****（2）排除生育政策干扰--方法一
use "C:\Users\admin\Desktop\财富与生育实证\new多期稳健性检验111.dta", clear

drop if year==2016 & age>100
gen age16=age if year==2016
bys pid: egen wanted = mean(age16)
replace wanted=age if wanted==.
drop age16 
rename wanted age16
gen agesy16=1 if age16>14 & age16<50
replace agesy16=0 if agesy16==.

gen treat18=0 
drop if 房屋拆迁14==1 
drop if 有无房屋拆迁16==1 
replace treat18=1 if 有无房屋拆迁18==1 
drop if 有无房屋拆迁18==0 &  有无房屋拆迁20==1
gen time18=9999
replace time18=2018 if 有无房屋拆迁18==1 
gen t2018=0 
replace t2018=1 if year>=time18
gen did2018=treat18*t2018

psmatch2 treat18 expen perhou_income tot_assets gender liv_area famsize mater_ins pGDP if agesy==1, out(childnum) logit ties ate neighbor(4) common
pstest expen perhou_income tot_assets gender liv_area famsize mater_ins pGDP if agesy==1, both graph

reghdfe childnum did2018 expen perhou_income tot_assets gender liv_area i.edu_p i.edu_fm famsize i.health trust exp_childedu mater_ins pGDP if agesy==1 & _support==1 & year>2014 [pweight=rswt_natpn1020], absorb(fid16 year) cluster(fid16)

****（3）排除生育政策干扰--方法二
use "C:\Users\admin\Desktop\财富与生育实证\new回归数据.dta", clear
gen 生育政策=1 if year>=2016
replace 生育政策=0 if year<2016
reghdfe childnum did11 生育政策 $control6 if _support==1 [pweight=rswt_natpn1012],absorb(fid14 year) cluster(fid14) 
est store m3
esttab m3 , mtitle(`mt')  b(%6.3f) se(%10.3f) nogap compress  ///
order($did11  $did11 ) ///
keep($did11  $did11 ) ///
star(* 0.1 ** 0.05 *** 0.01)   ar2 replace



