
 ********************************************	
***                描述统计              ***
********************************************
 ***最低工资
 
  //图1 1999-2007年中国城市月名义最低工资与实际最低工资
preserve
 keep year minwage_month cpi csdm
 gen minwage_month1=minwage_month*100/cpi
 sort csdm year
 bys csdm year : gen n = _n
 keep if n == 1
 drop n
  bys year: egen meanminwage_month=mean(minwage_month) 
 bys year: egen meanminwage_month1=mean(minwage_month1) 
 bys  year : gen n = _n
 keep if n == 1
 drop n 
twoway(connect meanminwage_month year,lpattern(dash) msymbol(Oh))(line meanminwage_month1 year),xlabel(1999(1)2007) ylabel(250(50)550)
 graph export "fig1.png",replace 
  gen meanminwage_month1__lag1 = meanminwage_month1[_n-1]
  gen growth=(meanminwage_month1-meanminwage_month1__lag1)/meanminwage_month1__lag1
restore 

 //图2 企业平均工资与城市最低工资的比率分布
  preserve
  keep year minwage rjgz
  ssc install distplot, replace
 ssc install astile,replace
  ssc install dataex,replace
  gen ratio1=rjgz/minwage
 drop if ratio1>5
 
 twoway(kdensity ratio1 if year==2000,bw(.2)  lpattern(1) xtitle("企业人均工资/城市最低工资") ytitle("Frequency") ) ///
 ||(kdensity ratio1 if year==2002,bw(.2) lpattern(1)) ///
  ||(kdensity ratio1 if year==2004,bw(.2) lpattern(1)) ///
   ||(kdensity ratio1 if year==2006,bw(.2) lpattern(1) ,xline(1)), ///
 legend (  label(1 2000) label(2 2002)  label(3 2004) label(4 2006))
  graph export "fig2.png",replace
 restore

 
  //表1 企业平均工资增长和初始平均工资
  preserve	
  keep  panelid year rjgz_lag1 rjgz csdm lnage lnsize lntfp lncapdes soeshare
 sort  panelid year
 gen Post04=1 if year>2003
 replace Post04=0 if Post04==.
 gen Post0203=1 if year==2002
 replace Post0203=1 if year==2003
 replace Post0203=0 if Post0203==.
 gen lnrjgz_lag1=log(rjgz_lag1)
 gen lnrjgz=log(rjgz)
 bys panelid:gen Δlnwage=lnrjgz-lnrjgz_lag1
 rename lnrjgz_lag1 lnwage 
 gen lnwage×Post04=lnwage*Post04
 gen lnwage×Post0203=lnwage*Post0203
 keep  Δlnwage lnwage lnwage×Post04 lnwage×Post0203  year panelid  csdm lnage lnsize lntfp lncapdes  soeshare 
 egen m=rowmiss(_all)
	drop if m>0
 xtset panelid year
 reghdfe Δlnwage lnwage lnwage×Post04 ,absorb(year csdm) vce(cluster panelid)
 estadd local "年份固定效应" "yes"
 estadd local "城市固定效应" "yes"
 est store z1 	
 reghdfe Δlnwage lnwage lnwage×Post04  lnage lnsize lntfp  lncapdes  soeshare, absorb(year csdm) vce(cluster panelid )
 estadd local "年份固定效应" "yes"
 estadd local "城市固定效应" "yes"
 est store z2 	
 reghdfe Δlnwage lnwage lnwage×Post04 lnwage×Post0203  lnage lnsize lntfp lncapdes  soeshare,absorb(year  csdm) vce(cluster panelid )
  estadd local "年份固定效应" "yes"
  estadd local "城市固定效应" "yes"
 est store z3 	
 esttab z1 z2 z3 using table1.rtf,mtitle(`mt') b(%6.4f)   ar2(%6.4f) t(%6.4f) nogap compress  ///
		star(* 0.1 ** 0.05 *** 0.01)  ///
		 scalars ("年份固定效应" "城市固定效应" N) ar2 replace 
 restore


 ***markdown
  
 //图4 1999-2007年中国工业企业抽成率均值
 preserve
 sort Markdown year
 gen ld=1 if ind2==13|ind2==14|ind2==15 |ind2==16|ind2==17|ind2==18|ind2==19|ind2==20
  gen zi=1 if ind2==21|ind2==22|ind2==23|ind2==24|ind2==25|ind2==26|ind2==27|ind2==28|ind2==29|ind2==30|ind2==31|ind2==32|ind2==33|ind2==34
  gen js=1 if ind2==35|ind2==36 |ind2==37|ind2==39 |ind2==40|ind2==41
  
bys year: egen meanMarkdown=mean(Markdown) 
bys year: egen ldMarkdown=mean(Markdown) if ld==1

bys year: egen ziMarkdown=mean(Markdown) if zi==1 

bys year: egen jsMarkdown=mean(Markdown) if js==1 

  twoway connected meanMarkdown ldMarkdown ziMarkdown jsMarkdown year,ytitle("抽成率平均值")xtitle("年份") ylabel(1.5(0.5)3)xlabel(1999(1)2007)scheme(s2manual)msymbol(triangle circle)
graph export "fig4.png",replace
   restore
   
 //图5 1999-2007 企业抽成率的产权特征
 
 preserve
 bys year: egen myMarkdown=mean(Markdown) if ownership==0

bys year: egen gyMarkdown=mean(Markdown) if ownership==1

bys year: egen gatMarkdown=mean(Markdown) if ownership==2

bys year: egen wzMarkdown=mean(Markdown) if ownership==3

  twoway connected myMarkdown gyMarkdown gatMarkdown wzMarkdown year,ytitle("抽成率平均值")xtitle("年份") ylabel(1(0.5)3)xlabel(1999(1)2007)scheme(s2manual)msymbol(triangle circle)
graph export "fig5.png",replace
 restore 
 
  ********************************************	
***                实证              ***
********************************************
 
 *生成did
 gen treat = 0
 replace treat = 1 if rjgz_lag1 < minwage   
 gen time = 1 if year > 2003
 replace time = 0 if time == .
 gen did = treat*time
 global control lnage lnsize lntfp lncapdes soeshare  lngdp lnpop
 
*基准回归
//表3最低工资制度实施对抽成率的影响
 preserve
 keep  lnMarkdown did  treat  year panelid  csdm $control
 egen m=rowmiss(_all)
	drop if m>0	
 xtset panelid year 
 reghdfe lnMarkdown did treat,absorb(year) vce(cluster panelid )
 estadd local year "yes"
 estadd local panelid "no"
 estadd local csdm "no"
 est store fe1

 xtset panelid year 
 reghdfe lnMarkdown did treat lnage lnsize lntfp  ,absorb(year panelid ) vce(cluster panelid)
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "no"
 est store fe2

 xtset panelid year 
 reghdfe lnMarkdown did treat  lnage lnsize lntfp lncapdes soeshare  ,absorb(year panelid csdm ) vce(cluster panelid)
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store fe3

 xtset panelid year 
 reghdfe lnMarkdown did treat  lnage lnsize lntfp lncapdes soeshare  lngdp lnpop , absorb(year panelid  csdm) vce(cluster panelid )
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store fe4
 
 esttab fe1 fe2 fe3 fe4 using table3.rtf,mtitle(`mt') b(%6.4f)  ar2(%6.4f) t(%6.4f) nogap compress  ///
		star(* 0.1 ** 0.05 *** 0.01)  ///
		 scalars(year panelid  csdm N) ar2 replace 
 restore
 
 //表4平行趋势检验结果
 preserve
 keep  lnMarkdown did  treat time year panelid  csdm $control
 egen m=rowmiss(_all)
	drop if m>0	
 gen pre_time=1 if year==2002|year==2003
 replace pre_time= 0 if pre_time== .
 gen predid=treat*pre_time
 xtset panelid year
 reghdfe lnMarkdown did predid treat  $control  ,absorb(year panelid  csdm) vce( cluster panelid )
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store p1
 restore  

 preserve
 keep lnMarkdown did treat  panelid year  csdm $control
 egen m=rowmiss(_all)
	drop if m>0
 sort panelid year
 bys panelid : gen year2=year[_n-2]
 gen gapyear2= year2-year
 bys panelid : gen lnMarkdown_lag2 = lnMarkdown[_n-2] if gapyear2==-2
 drop if lnMarkdown_lag2==.
 xtset panelid year
 reghdfe lnMarkdown_lag2 did treat $control  ,absorb(year panelid csdm) vce(cluster panelid )
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store p2
 restore 

 preserve
 keep lnMarkdown did treat  panelid year  csdm $control
 egen m=rowmiss(_all)
	drop if m>0
 sort panelid year
 bys panelid :gen year1=year[_n+1]
 gen gapyear1= year1-year
 bys panelid :gen treat_1=treat[_n+1] if gapyear1==1
 gen shock=treat_1-treat
 drop if shock==1
 xtset panelid year
 reghdfe lnMarkdown did treat  $control  ,absorb(year panelid  csdm) vce(cluster panelid )
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store p3
 esttab p1 p2 p3 using table4.rtf,mtitle(`mt') b(%6.4f)  ar2(%6.4f) t(%6.4f) nogap compress  ///
		star(* 0.1 ** 0.05 *** 0.01)  ///
		 scalars(year panelid   csdm N) ar2 replace 
 restore 
 
 //表5工具变量回归结果
  preserve 
  keep csdm ind2 year rjgz L
  bys csdm ind2 year : egen rjgz_c = mean(rjgz) //每一年每个城市每个行业的平均工资
  bys csdm ind2 year : egen L_c = total(L) // 每一年每个城市每个行业的从业人员
  bys csdm year : egen L_total = total(L) // 每一年每个城市所有行业的从业人员 
  bys csdm ind2 year : gen n = _n
  keep if n == 1
  drop n
  rangestat(mean)rjgz_c,interval(ind2 0 0) by(year) exclude  // 每一年除了该城市以外 全国其他城市在每个行业的平均工资
  sort csdm ind2 year
  bys csdm ind2 : gen year_lag1 = year[_n-1]
  bys csdm ind2 : gen year_lag2 = year[_n-2]
  gen gapyear1 = year - year_lag1
  gen gapyear2= year - year_lag2

  bys csdm ind2 : gen rjgz_c_mean_lag1 = rjgz_c_mean[_n-1] if gapyear1 == 1
  bys csdm ind2 year : egen X = mean(rjgz_c_mean_lag1)
  replace rjgz_c_mean_lag1 = X
  drop X // wage1: 除了该城市以外 全国其他城市 在每个行业 在t-1的年平均工资
  
  bys csdm ind2 : gen rjgz_c_mean_lag2 = rjgz_c_mean[_n-2] if gapyear2 == 2
  bys csdm ind2 year: egen X = mean(rjgz_c_mean_lag2)
  replace rjgz_c_mean_lag2 = X
  drop X // wage2: 除了该城市以外 全国其他城市 在每个行业 在t-2的年平均工资

  bys csdm ind2 : gen rjgz_c_lag1 = rjgz_c[_n-1] if gapyear1 == 1
  bys csdm ind2 year: egen X = mean(rjgz_c_lag1)
  replace rjgz_c_lag1 = X
  drop X // wage3: 每个城市的每个行业在t-1年的平均工资

  bys csdm ind2 : gen L_c_lag2 = L_c[_n-2] if gapyear2 == 2
  bys csdm ind2 year: egen X = mean(L_c_lag2)
  replace L_c_lag2 = X
  drop X // L1: 每个城市每个行业 在t-2年的从业人员
  
  bys csdm ind2 : gen L_total_lag2 = L_total[_n-2] if gapyear2 == 2
  bys csdm ind2 year: egen X = mean(L_total_lag2)
  replace L_total_lag2 = X
  drop X // L2: 每个城市 在t-2年 所有行业的从业人员
  
  gen WW = (L_c_lag2/L_total_lag2)*(rjgz_c_mean_lag1/rjgz_c_mean_lag2)*rjgz_c_lag1
  bys csdm year : egen WW_total = total(WW) 
  replace WW_total = . if WW_total  == 0
  label var WW_total "工具变量"
  keep csdm year WW_total   
  bys csdm year : gen n = _n
  keep if n == 1
  drop n
  save "工具变量.dta",replace
  restore
  
 preserve
 merge  n:1  csdm year using  "E:\Stata data\实证结果\20231104\工具变量.dta"
 keep if _merge == 3
 drop _merge
 gen newminwage=0.4*WW_total
 drop if newminwage==.
 gen treat1=1 if rjgz_lag1 < newminwage
 replace treat1=0 if treat1==.
 gen did1=treat1*time
 keep  lnMarkdown did did1 treat1 treat  year panelid  csdm $control
 egen m=rowmiss(_all)
	drop if m>0	
 xtset panelid year
 reghdfe treat treat1 did1  $control ,absorb(year panelid csdm) vce(cluster panelid )
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store g1

 reghdfe did treat1 did1  $control ,absorb(year panelid csdm) vce(cluster panelid )
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store g2

 xtset panelid year 
ivreghdfe lnMarkdown $control (did treat = did1 treat1) ,absorb(year panelid csdm  ) vce(cluster panelid ) 
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store g3

 esttab  g1 g2 g3 using table5.rtf,mtitle(`mt') b(%6.4f)  ar2(%6.4f) t(%6.4f) nogap compress  ///
		star(* 0.1 ** 0.05 *** 0.01)  ///
		 scalars(year panelid  csdm N) ar2 replace 
  restore
 
 //表6稳健性检验
 gen sqdm1=real(substr(string(csdm),1,2))
*东部
gen area= 1 if /*

	*/ sqdm1 == 11 | /* 
	*/ sqdm1== 12 | /* 
	*/ sqdm1== 13 | /* 
	*/ sqdm1 == 31 | /* 
	*/ sqdm1 ==32  | /* 
	*/ sqdm1== 33 | /* 
	*/ sqdm1 == 35| /* 
	*/ sqdm1 == 37 | /* 
	*/ sqdm1 == 44 | /* 
	*/ sqdm1== 46
*中部
replace area = 2 if /*
	*/  sqdm1 == 14 | /* 
	*/  sqdm1== 34| /* 
	*/  sqdm1==36 | /* 
	*/  sqdm1== 41 | /* 
	*/  sqdm1 ==42 | /* 
	*/  sqdm1== 43
	
*西部
replace area = 3 if /*
	*/   sqdm1== 45 | /* 
	*/   sqdm1== 55 | /* 
	*/   sqdm1== 51| /* 
	*/   sqdm1== 52 | /* 
	*/   sqdm1== 53| /* 
	*/  sqdm1 ==61| /* 
	*/  sqdm1 ==62 | /* 
	*/  sqdm1 == 63 | /* 
	*/  sqdm1 == 64 | /* 
	*/  sqdm1 == 65| /* 
	*/  sqdm1 == 15

*东北
replace area = 4 if /* 
	*/   sqdm1== 21| /* 
	*/  sqdm1 == 22 | /* 
	*/  sqdm1 ==23


//稳健性检验1:将最低工资政策的实施时间变量 Post 2004由1替换为5/6
 preserve
 gen time1=1 if year>2003
 replace time1=0 if time1==.
 replace time1=5/6 if year==2004
 gen didwenjian=treat*time1
 keep lnMarkdown didwenjian treat  panelid year   csdm  $control
 egen m=rowmiss(_all)
	drop if m>0
 xtset panelid year
 reghdfe lnMarkdown didwenjian treat  $control ,absorb(year panelid  csdm) vce(cluster panelid )
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store w1
 restore


//稳健性检验2:将交乘项 did替换为连续变量最低工资标准lnminwage得到的估计结果
 preserve
 gen lnminwage=log(minwage)
 keep lnMarkdown lnminwage panelid year   csdm  $control 
 egen m=rowmiss(_all)
	drop if m>0
 xtset panelid year
 reghdfe lnMarkdown lnminwage  $control  ,absorb(year panelid  csdm) vce(cluster panelid)
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store w2
 restore 


//稳健性检验3:剔除平均工资高于非暴露(高工资)公司中观察到的中值，并低于暴露(低工资)公司的第一个十分位数样本		
 preserve		 
 keep treat panelid year rjgz
 drop if treat==1
 sort  panelid year
 bys year:   egen rjgz_50_t0=pctile(rjgz),p(50)
 keep  year rjgz_50_t0
 bys year : gen n = _n
 keep if n == 1
 drop n
 save treat_rjgz_50_t0.dta,replace
 restore 
		 
 preserve		 
 keep treat panelid year rjgz
  drop if treat==0
 sort  panelid year
 bys year:   egen rjgz_10_t1=pctile(rjgz),p(10)
 keep  year rjgz_10_t1
 bys year : gen n = _n
 keep if n == 1
 drop n
 save treat_rjgz_10_t1.dta,replace
 restore 		 
	
 preserve
 merge  n:1 year using 	"E:\Stata data\实证结果\20230910\treat_rjgz_50_t0.dta"
 drop _merge		 		 
 merge  n:1 year using 	"E:\Stata data\实证结果\20230910\treat_rjgz_10_t1.dta"
 drop _merge		 		 
 drop if rjgz>rjgz_50_t0
 drop if rjgz<rjgz_10_t1
 keep  lnMarkdown did  treat time year panelid  csdm $control
 egen m=rowmiss(_all)
	drop if m>0			 
 xtset panelid year 
 reghdfe lnMarkdown did treat  $control, absorb(year panelid csdm) vce(cluster panelid )
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store w3
 restore	

//稳健性检验4:考虑2004年参与WTO影响 删除计算机和纺织业的回归结果 剔除样本期间出口最多的行业，如纺织服装、鞋、帽制造业，以及通信设备、计算机及其他电子设备制造业等
 preserve
 drop if ind2==17 //纺织业
 drop if ind2==18 //纺织服装、鞋、帽制造业
 drop if ind2==40 //通信设备、计算机及其他电子设备
 keep lnMarkdown did treat  panelid year ind2  csdm  $control
 egen m=rowmiss(_all)
	drop if m>0
 xtset panelid year
 reghdfe lnMarkdown did treat  $control ,absorb(year panelid  csdm) vce(cluster panelid )
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store w4
 restore

		 
 //稳健性检验5:考虑到国有企业改革的影响，由于东北地区的国有企业受国企改革影响最大，所以剔除东北地区的样本
 preserve
 drop if area == 4
 keep lnMarkdown did treat panelid year area csdm  $control
 egen m=rowmiss(_all)
	drop if m>0
 xtset panelid year
 reghdfe lnMarkdown did treat  $control ,absorb(year panelid  csdm) vce(cluster panelid)
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store w5
 restore
  esttab w1 w2 w3 w4 w5 using table6.rtf,mtitle(`mt') b(%6.4f)  ar2(%6.4f) t(%6.4f) nogap compress  ///
		star(* 0.1 ** 0.05 *** 0.01)  ///
		 scalars(year panelid  csdm N) ar2 replace 

 
 //表7：稳健性检验：剔除高工资企业样本
   preserve
   bys year: egen rjgz_80=pctile(rjgz),p(80) 
 gen highwage80=(rjgz>rjgz_80 )
       bys year: egen rjgz_50=pctile(rjgz),p(50)
 gen highwage50=(rjgz>rjgz_50 ) 
    bys year: egen rjgz_20=pctile(rjgz),p(20)
 gen highwage20=(rjgz>rjgz_20 ) 
 keep lnMarkdown did treat  $control highwage80  highwage50 highwage20 year panelid  csdm
  egen p=rowmiss(_all)
	drop if p>0
 xtset panelid year  

 reghdfe lnMarkdown did treat  $control if  highwage80==0 ,absorb(year panelid  csdm) vce(cluster panelid )
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store f1
 
     reghdfe lnMarkdown did treat  $control if highwage50==0  ,absorb(year panelid  csdm) vce(cluster panelid )
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store f2
 
   reghdfe lnMarkdown did treat  $control if highwage20==0  ,absorb(year panelid  csdm) vce(cluster panelid )
   
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store f3
 restore 	
 
 esttab f1 f2 f3 using table7.rtf,mtitle(`mt') b(%6.4f)  ar2(%6.4f) t(%6.4f) nogap compress  ///
		star(* 0.1 ** 0.05 *** 0.01)  ///
		 scalars(year panelid  csdm N) ar2 replace 



  *异质性分析

//表8企业异质性回归结果
//分劳动密集度

 preserve
  gen labor=L/gdzchj
  bys year :   egen xbar = median (labor)
 gen labori=1 if labor>xbar
 replace labori=0 if labori==.
 keep lnMarkdown did treat  $control labori year panelid csdm
 egen m=rowmiss(_all)
	drop if m>0	
 xtset panelid year
 reghdfe lnMarkdown did treat  $control if labori==1,absorb(year panelid csdm) vce(cluster panelid)
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
  est store l1 //劳动密集
  reghdfe lnMarkdown did treat  $control if labori==0,absorb(year panelid  csdm) vce(cluster panelid)
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store l2 //非劳动密集
 esttab l1 l2   using laborindus.rtf,mtitle(`mt') b(%6.4f)  ar2(%6.4f) t(%6.4f) nogap compress  ///
		star(* 0.1 ** 0.05 *** 0.01)  ///
		 scalars(year panelid   csdm N) ar2 replace 
 restore
 
 //2004年企业分高低技能企业  大学本科以及以上
 preserve
 keep lnMarkdown did treat  $control high year panelid csdm
 egen m=rowmiss(_all)
	drop if m>0	
 xtset panelid year
 reghdfe lnMarkdown did treat  $control if high==1,absorb(year panelid csdm) vce(cluster panelid)
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
  est store j1 //高技能
  reghdfe lnMarkdown did treat  $control if high==0,absorb(year panelid  csdm) vce(cluster panelid)
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store j2 //低技能
 esttab j1 j2   using skill.rtf,mtitle(`mt') b(%6.4f)  ar2(%6.4f) t(%6.4f) nogap compress  ///
		star(* 0.1 ** 0.05 *** 0.01)  ///
		 scalars(year panelid   csdm N) ar2 replace 
 restore
 
 //企业规模 分大型中型和小型企业
 preserve
 gen ss=zczj>40000|zczj==40000
  replace ss=3 if zczj<4000
  replace ss=2 if ss==0 
   keep lnMarkdown did treat  $control ss year panelid csdm
 egen m=rowmiss(_all)
	drop if m>0
reghdfe lnMarkdown did treat  $control if ss==1 ,absorb(year panelid csdm) vce(cluster panelid)
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store s1	
  reghdfe lnMarkdown did treat  $control if ss==2 ,absorb(year panelid csdm) vce(cluster panelid)
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store s2
   reghdfe lnMarkdown did treat  $control if ss==3 ,absorb(year panelid csdm) vce(cluster panelid)
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store s3

 esttab s1 s2 s3 using scale.rtf,mtitle(`mt') b(%6.4f)  ar2(%6.4f) t(%6.4f) nogap compress  ///
		star(* 0.1 ** 0.05 *** 0.01)  ///
		 scalars(year panelid  csdm N) ar2 replace 
  restore 

//表9企业产权异质性回归结果
 preserve
 keep lnMarkdown did treat time panelid year  csdm ownership $control
 egen m=rowmiss(_all)
	drop if m>0	
 reghdfe lnMarkdown did treat  $control if ownership==0,absorb(year panelid  csdm) vce(cluster panelid)
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store o1 //民营
 reghdfe lnMarkdown did treat  $control if ownership==1,absorb(year panelid csdm) vce(cluster panelid)
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store o2 //国有
 reghdfe lnMarkdown did treat  $control if ownership==2,absorb(year panelid  csdm) vce(cluster panelid)
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store o3 //港澳台
 reghdfe lnMarkdown did treat  $control if ownership==3,absorb(year panelid  csdm) vce(cluster panelid )
 estadd local year "yes"
 estadd local panelid "yes"
 estadd local csdm "yes"
 est store o4 //外资
 esttab o1 o2 o3 o4 using ownership.rtf,mtitle(`mt') b(%6.4f)  ar2(%6.4f) t(%6.4f) nogap compress  ///
		star(* 0.1 ** 0.05 *** 0.01)  ///
		 scalars(year panelid  csdm N) ar2 replace 
 restore

 //表10影响机制检验
  preserve
  gen lnrjgz=log(rjgz)
  gen hegui=0 if rjgz< minwage
  replace hegui=1 if hegui==.	
  gen cs=1 if csdm>0
   bys csdm year :egen sumcs=sum(cs)
  bys csdm year :egen sumhgeui=sum(hegui)
  gen policy=sumhgeui/sumcs
  gen lnpolicy=log(policy)
  gen lnl=log(L)
  gen mrpl=Markdown*rjgz
 gen lnmrpl=log(mrpl)
 keep lnMarkdown did treat time panelid year csdm  $control lnrjgz lnpolicy lnl lnmrpl
 egen m=rowmiss(_all)
	drop if m>0	
reghdfe lnrjgz did treat  $control ,absorb(year panelid  csdm) vce(cluster panelid)
est store jz1
reghdfe lnmrpl did treat  $control ,absorb(year panelid  csdm) vce(cluster panelid)
est store jz2
  reghdfe lnpolicy did treat  $control ,absorb(year panelid  csdm) vce(cluster panelid)
est store jz3
reghdfe lnl did treat  $control ,absorb(year panelid  csdm) vce(cluster panelid)
est store jz4

esttab jz1 jz2  jz3 jz4 using table10.rtf,mtitle(`mt') b(%6.4f) ar2(%9.4f) t(%7.4f) nogap compress  ///
		star(* 0.1 ** 0.05 *** 0.01)  ///
		 scalars(year panelid  ind3_2 N) ar2 replace 
 restore 
 
 