
clear
use 基准数据.dta 
xtset code year 
set scheme s1mono
global xlist  "lnagdp ind finance gov internet"
********************************描述性统计********************************
sum pnum ent  reform $xlist
logout, save (相关变量描述性统计) excel replace: tabstat pnum ent reform agdp ind finance gov internet , s(n mean sd min max) f(%12.3f) c(s)
********************************一、基准回归********************************
reg ent reform, r
outreg2 using 基准回归.doc,replace tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform) addtext(city fe, no,year fe, no)
xtreg ent reform   i.year , fe robust
outreg2 using 基准回归.doc,append tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform) addtext(city fe, yes,year fe, yes)
reg ent reform  $xlist, r
outreg2 using 基准回归.doc,append tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform $xlist) addtext(city fe, no,year fe, no)
xtreg ent reform  $xlist i.year , fe robust 
outreg2 using 基准回归.doc,append tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform $xlist ) addtext(city fe, yes,year fe, yes)

*******************************二、平行趋势检验********************************
gen event = year - reformtime
replace event = -3 if event<= -3
replace event = 4 if event >= 4
gen before3 = (event==-3)
gen before2 = (event==-2)
gen before1 = (event==-1)
gen current = (event==0 )
gen after1 = (event==1 )
gen after2 = (event==2 )
gen after3 = (event==3 )
gen after4 = (event==4 )
drop before1
xtreg ent before3 before2  current after1 after2 after3 after4  $xlist i.year, fe r

coefplot, ///
   keep(before3 before2  current after1 after2 after3 after4)  ///
   vertical                       ///
   yline(0)                       ///
   ytitle("估计系数")               ///
   xtitle("“营改增”推行相对时间") ///
   addplot(line @b @at)                 ///
   ciopts(recast(rcap))                 ///
   scheme(s1mono) 
graph export "平行趋势检验.png",as(png) replace width(800) height(800)

********************************三、反事实检验********************************
*提前一期
gen reformtime1=reformtime-1
gen reform1= year- reformtime1
replace reform1=1 if reform1>=0
replace reform1=0 if reform1<=-1
xtreg ent reform1 $xlist i.year , fe robust
outreg2 using 反事实检验.doc,replace tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform1 $xlist ) addtext(city fe, yes,year fe, yes)

*推迟一期
gen reformtime3=reformtime+1
gen reform3= year- reformtime3
replace reform3=1 if reform3>=0
replace reform3=0 if reform3<=-1
xtreg ent reform3 $xlist i.year , fe robust
outreg2 using 反事实检验.doc,append tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform3 $xlist ) addtext(city fe, yes,year fe, yes)

*安慰剂检验
clear
set matsize 5000
mat b = J(1000,1,0)
mat se = J(1000,1,0)
mat p = J(1000,1,0)

forvalues i=1/1000{

		
	*伪政策虚拟变量
	use "基准数据.dta",clear 
	bsample 1, strata(code)
	keep code year
	rename year policy_year
	save "matchyear.dta", replace
	merge 1:m code using "基准数据.dta"
	xtset code year
    gen did=(year>= policy_year)
	global xlist "lnagdp ind finance internet gov "	
	qui xtreg ent did  $xlist  i.year, fe robust
	
	mat b[`i',1] = _b[did]
	mat se[`i',1] = _se[did]
	scalar df_r = e(N) - e(df_m) -1
	mat p[`i',1] = 2*ttail(df_r,abs(_b[did]/_se[did]))
}
svmat b, names(coef)
svmat se, names(se)
svmat p, names(pvalue)
drop if pvalue1 == .
label var pvalue1 p值
label var coef1 估计系数
twoway (kdensity coef1,  yaxis(2)) (scatter pvalue1 coef1, yaxis(1)  msymbol(smcircle_hollow) mcolor(black)), ///
xlabel(-0.1(0.05)0.2 0.14) ylabel(0(0.5)1.5 0.1,angle(0)) ///
xline(0.14, lwidth(vthin) lp(shortdash)) xtitle("估计系数") ///
yline(0.1,lwidth(vthin) lp(dash)) ytitle(p值, axis(1)) ///
ytitle(密度, axis(2)) ///
legend(label(1 "估计系数分布") label( 2 "p值")) ///
plotregion(style(none)) ///
graphregion(color(white)) 

********************************四、稳健性检验********************************
*1.PSM-DID
graph set window fontface     "times new roman"
graph set window fontfacesans "宋体"
set scheme s1color
clear
use 基准数据.dta 
xtset code year 
global xlist  "lnagdp ind finance internet gov "
**# 1.1 卡尺最近邻匹配（1:2）
set  seed 0000
gen  norvar_1 = rnormal()
sort norvar_1
psmatch2 reform lngdp ind structure, outcome(ent) logit neighbor(2) ties common ate caliper(0.02)
save psmdata.dta, replace
**# 1.2 平衡性检验
pstest lngdp ind structure, both graph saving(balancing_assumption, replace)
graph export "balancing_assumption.emf", replace
psgraph, saving(common_support, replace)
graph export "common_support.emf", replace
**# 1.3 倾向得分值的核密度图
sum _pscore if reform == 1, detail  
*- 匹配前
sum _pscore if reform == 0, detail
twoway(kdensity _pscore if reform == 1, lpattern(solid)                     ///
              lcolor(black)                                                  ///
              lwidth(thin)                                                   ///
              scheme(qleanmono)                                              ///
              ytitle("{stsans:核}""{stsans:密}""{stsans:度}",                ///
                     size(medlarge) orientation(h))                          ///
              xtitle("{stsans:匹配前的倾向得分值}",                          ///
                     size(medlarge))                                         ///
              xline(0.4732   , lpattern(solid) lcolor(black))                ///
              xline(`r(mean)', lpattern(dash)  lcolor(black))                ///
              saving(kensity_cs_before, replace))                            ///
      (kdensity _pscore if reform == 0, lpattern(dash)),                    ///
      xlabel(     , labsize(medlarge) format(%02.1f))                        ///
      ylabel(0(1)4, labsize(medlarge))                                       ///
      legend(label(1 "{stsans:处理组}")                                      ///
             label(2 "{stsans:控制组}")                                      ///
             size(medlarge) position(1) symxsize(10))

graph export "kensity_cs_before.emf", replace
discard
*- 匹配后
sum _pscore if reform== 0 & _weight != ., detail
twoway(kdensity _pscore if reform == 1, lpattern(solid)                     ///
              lcolor(black)                                                  ///
              lwidth(thin)                                                   ///
              scheme(qleanmono)                                              ///
              ytitle("{stsans:核}""{stsans:密}""{stsans:度}",                ///
                     size(medlarge) orientation(h))                          ///
              xtitle("{stsans:匹配后的倾向得分值}",                          ///
                     size(medlarge))                                         ///
              xline(0.4732   , lpattern(solid) lcolor(black))                ///
              xline(`r(mean)', lpattern(dash)  lcolor(black))                ///
              saving(kensity_cs_after, replace))                             ///
      (kdensity _pscore if reform == 0 & _weight != ., lpattern(dash)),     ///
      xlabel(     , labsize(medlarge) format(%02.1f))                        ///
      ylabel(0(1)4, labsize(medlarge))                                       ///
      legend(label(1 "{stsans:处理组}")                                      ///
             label(2 "{stsans:控制组}")                                      ///
             size(medlarge) position(1) symxsize(10))

graph export "kensity_cs_after.emf", replace
discard
gen common = _support
*去除不满足共同区域假定的观测值
drop if common == 0
*回归结果
use psmdata.dta, clear
xtset code year 
xtreg ent reform _pscore  $xlist  i.year if _support == 1, fe robust
outreg2 using 稳健性检验.doc, tstat bdec(3) tdec(2) rdec(3) ctitle(pnum) keep(reform $xlist) addtext(city fe, yes,year fe, yes)

*2.更换创业指标（总量）
clear
use 基准数据.dta 
xtset code year 
set scheme s1mono
global xlist  "lnagdp ind finance internet gov "
xtreg lnpnum reform  $xlist i.year, fe robust
outreg2 using 稳健性检验.doc,append tstat bdec(3) tdec(2) rdec(3) ctitle(lnpnum) keep(reform $xlist) addtext(city fe, yes,year fe, yes)
***************3.扩充样本期/缩尾处理





xtreg ent reform  $xlist i.year, fe robust




outreg2 using 稳健性检验.doc, append tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform $xlist) addtext(city fe, yes,year fe, yes)
winsor2 ent $xlist, replace cuts(1 99)
xtreg ent reform $xlist  i.year, fe robust 
outreg2 using 稳健性检验.doc,append tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform $xlist) addtext(city fe, yes,year fe, yes)
*4.省份层面聚类
xtreg ent reform  $xlist i.year, fe vce (cluster provincecode)
outreg2 using 稳健性检验.doc,append tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform $xlist) addtext(city fe, yes,year fe, yes)
*5.异质性处理效应
did_multiplegt ent code year reform, controls(lnagdp ind finance internet gov) cluster(code)  // DIDM估计量
csdid ent lnagdp ind finance internet gov, ivar(code) time(year) gvar(reformtime) agg(simple) method(drimp) notyetlong rseed(1)  // C&S(2021)  simple 表示 采用普通方式加权 CSDID估计量
*6.排除创业政策的影响 
gen policy1=year-创新城市
replace policy1 = 1 if policy1 >= 0&policy1!=.
replace policy1 = 0 if policy1 < 0
replace policy1 = 0 if policy1==.
xtreg ent reform $xlist policy1 i.year, fe robust    //创新城市试点
outreg2 using 排除竞争性解释.doc,replace tstat bdec(3) tdec(2) rdec(3) ctitle(policy1) keep(reform policy1 $xlist) addtext(city fe, yes,year fe, yes)
gen policy2=year-宽带中国
replace policy2 = 1 if policy2 >= 0&policy2!=.
replace policy2 = 0 if policy2 < 0
replace policy2 = 0 if policy2==.
xtreg ent reform $xlist policy2 i.year, fe robust    //宽带中国城市试点
outreg2 using 排除竞争性解释.doc,append tstat bdec(3) tdec(2) rdec(3) ctitle(policy2) keep(reform policy2 $xlist) addtext(city fe, yes,year fe, yes)

********************************六、异质性分析********************************
*1.产业结构差异
astile ind_p50= ind3 ,nq(2)
xtreg ent reform  $xlist i.year if ind_p50==1, fe robust
outreg2 using 异质性分析.doc, replace tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform $xlist) addtext(city fe, yes,year fe, yes)
xtreg ent reform  $xlist i.year if ind_p50==2, fe robust
outreg2 using 异质性分析.doc, append tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform $xlist) addtext(city fe, yes,year fe, yes)
*2.城市类别差异
xtreg ent reform  $xlist i.year if 创业城市==1, fe robust
outreg2 using 异质性分析.doc, append tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform $xlist) addtext(city fe, yes,year fe, yes)
xtreg ent reform  $xlist i.year if 创业城市==0, fe robust
outreg2 using 异质性分析.doc, append tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform $xlist) addtext(city fe, yes,year fe, yes)

********************************七、拓展性分析********************************
*1.受改革影响程度的调节
gen reform_influence=reform*influence
xtreg ent reform reform_influence $xlist i.year , fe robust
outreg2 using 拓展性分析.doc,replace tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform reform_influence) addtext(city fe, yes,year fe, yes)
*2.税收依赖和财政自主权的调节
*财政自主权
gen reform_autonomy=reform*autonomy
xtreg ent reform reform_autonomy $xlist i.year , fe robust
outreg2 using 拓展性分析.doc, tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform reform_autonomy) addtext(city fe, yes,year fe, yes)
*税收依赖程度
gen reform_tax=reform*tax
xtreg ent reform reform_tax $xlist i.year , fe robust
outreg2 using 拓展性分析.doc, tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform reform_tax) addtext(city fe, yes,year fe, yes)
*3.政府创业配套政策的调节
gen lnpolicy=ln(policy+1)
gen reform_lnpolicy=reform*lnpolicy
xtreg ent reform  reform_lnpolicy $xlist i.year, fe robust
outreg2 using 拓展性分析.doc, tstat bdec(3) tdec(2) rdec(3) ctitle(ent) keep(reform reform_lnpolicy) addtext(city fe, yes,year fe, yes)
********************************五、影响机制检验********************************
1.减税效应（见税收文件）




