
*====================================================================
**** 数智化转型平抑了制造企业供应链风险吗？—基于供需关系的视角
****【作  者】：郭家琛  赵景峰  刘珊  王智新
****【单  位】：西北大学经济管理学院 河北大学经济学院
****【期  刊】：《经济评论》
****【软  件】：Stata 17, 所有的package都需要升级到最新版本
****【数据来源】：CSMAR数据库、上市公司前五大供应商和客户数据、中国城市统计年鉴
****【联系邮箱】：denmarkchen@163.com
****【版本日期】：2024-08-05
*====================================================================

*=======================================================================================
	****表1 描述性统计*****
*=======================================================================================
global  control   "lp  ROE   GDPsp Ainternet Dual MB Balance  INDEP  SOE "

sum SSC SSCsupplier  SSCcustomer DIT  $control 

*=======================================================================================
	****表2 基准回归*****
*=======================================================================================
xtreg SSC DIT   i.year i.ind i.province ,fe  cluster(id)
xtreg SSC DIT   $control i.year i.ind i.province  ,fe  cluster(id)
xtreg SSCsupplier DIT    $control  i.year i.ind i.province ,fe  cluster(id)
xtreg SSCcustomer DIT    $control  i.year  i.ind i.province  ,fe  cluster(id)


*=======================================================================================
	****表3 工具变量法*****
*=======================================================================================
xtreg SSC DIT IV1  $control  i.year i.ind i.province  ,fe  cluster(id)
xtreg  DIT IV1  $control  i.year i.ind i.province  ,fe  cluster(id)
xtivreg SSC   $control (DIT =IV1)  i.year i.ind i.province  ,fe vce(cluster id)
 
xtreg SSC DIT IV2  $control  i.year i.ind i.province  ,fe  cluster(id)
xtreg  DIT IV2  $control  i.year i.ind i.province  ,fe  cluster(id)
xtivreg SSC   $control (DIT =IV2) i.year  i.ind i.province  ,fe vce(cluster id) 


*=======================================================================================
	****表4 Keckman两步法*****
*=======================================================================================
****Heckman
xtreg SSC DIT  imr   i.year  i.ind i.province  ,fe  cluster(id)
xtreg SSC DIT  imr  $control  i.year  i.ind i.province  ,fe  cluster(id)

************psmdid检验、平行趋势检验安慰剂检验见最下方

*=======================================================================================
	****表6 稳健性检验*****
*=======================================================================================
xtreg  SSCH   DIT  $control i.year i.ind i.province  ,fe  cluster(id)
xtreg  SSC   DITstd  $control i.year i.ind i.province  ,fe  cluster(id)
xtreg  SSC    DITinn  $control i.year i.ind i.province  ,fe  cluster(id)

reghdfe SSC DIT   $control , absorb(year ind province id) cluster(ind)
xtreg SSC DIT   $control i.year i.ind i.province i.year#ind ,fe  cluster(id)
xtset id year
xtreg  SSC    L.DIT  $control i.year i.ind i.province  ,fe  cluster(id)


*=======================================================================================
	****表7 敏感性检验*****
*=======================================================================================
xtreg SSC DIT   $control  i.year  i.ind i.province  ,fe  cluster(id)
psacalc delta DIT, beta(0) rmax(0.06032) 
psacalc beta DIT, delta(1) rmax(0.06032)

*=======================================================================================
	****表8 异质性检验*****
*=======================================================================================
xtreg SSC  Foreign_r  Invest1 Invest_1 $control i.year i.ind i.province ,fe  cluster(id)
xtreg SSC  Foreign_m  Invest2 Invest_2 $control i.year i.ind i.province ,fe  cluster(id)
xtreg SSC  EU  envi1 envi_1  $control i.year i.ind i.province ,fe  cluster(id)


*=======================================================================================
	****表9 机制检验*****
*=======================================================================================
xtreg ICDA DIT   $control  i.year i.ind i.province  ,fe  cluster(id)
xtreg ITR DIT   $control  i.year i.ind i.province  ,fe  cluster(id)
xtreg RD DIT   $control  i.year i.ind i.province  ,fe  cluster(id)



*=======================================================================================
	****附表3 异质性检验：基于不同生命周期和行业属性的考虑*****
*=======================================================================================
***仅考虑行业属性
xtreg SSC DIT $control i.year i.ind i.province if dense ==1 ,fe  cluster(id)
xtreg SSC DIT $control i.year i.ind i.province if dense ==2,fe  cluster(id)
xtreg SSC DIT $control i.year i.ind i.province if dense ==3,fe  cluster(id)

***考虑生命周期***
xtreg SSC DIT $control i.year i.ind i.province if dense ==1&lifeCycle==1,fe  cluster(id)
xtreg SSC DIT $control i.year i.ind i.province if dense ==1&lifeCycle==2,fe  cluster(id)
xtreg SSC DIT $control i.year i.ind i.province if dense ==1&lifeCycle==3,fe  cluster(id)

xtreg SSC DIT $control i.year i.ind i.province if dense ==2&lifeCycle==1,fe  cluster(id)
xtreg SSC DIT $control i.year i.ind i.province if dense ==2&lifeCycle==2,fe  cluster(id)
xtreg SSC DIT $control i.year i.ind i.province if dense ==2&lifeCycle==3,fe  cluster(id)

xtreg SSC DIT $control i.year i.ind i.province if dense ==3&lifeCycle==1,fe  cluster(id)
xtreg SSC DIT $control i.year i.ind i.province if dense ==3&lifeCycle==2,fe  cluster(id)
xtreg SSC DIT $control i.year i.ind i.province if dense ==3&lifeCycle==3,fe  cluster(id)



*=======================================================================================
	****附表4  信息流、实物流及资金流沿供应链上下游互动关系的影响效果*****
*=======================================================================================

***信息流
xtreg SSCsupplier DIT   $control  i.year i.ind i.province if v1==3 ,fe  cluster(id)
xtreg SSCsupplier DIT   $control  i.year i.ind i.province if v1==2 ,fe  cluster(id)
xtreg SSCsupplier DIT   $control  i.year i.ind i.province if v1==1 ,fe  cluster(id)

xtreg SSCcustomer DIT   $control  i.year i.ind i.province if v1==3 ,fe  cluster(id)
xtreg SSCcustomer DIT   $control  i.year i.ind i.province if v1==2 ,fe  cluster(id)
xtreg SSCcustomer DIT   $control  i.year i.ind i.province if v1==1, fe  cluster(id)

*****实物流
xtreg SSCsupplier DIT   $control  i.year i.ind i.province if v3==3 ,fe  cluster(id)
xtreg SSCsupplier DIT   $control  i.year i.ind i.province if v3==2 ,fe  cluster(id)
xtreg SSCsupplier DIT   $control  i.year i.ind i.province if v3==1,fe  cluster(id)

xtreg SSCcustomer DIT   $control  i.year i.ind i.province if v3==3 ,fe  cluster(id)
xtreg SSCcustomer DIT   $control  i.year i.ind i.province if v3==2 ,fe  cluster(id)
xtreg SSCcustomer DIT   $control  i.year i.ind i.province if v3==1,fe  cluster(id)

***资金流
xtreg SSCsupplier DIT   $control  i.year i.ind i.province if v2==3 ,fe  cluster(id)
xtreg SSCsupplier DIT   $control  i.year i.ind i.province if v2==2 ,fe  cluster(id)
xtreg SSCsupplier DIT   $control  i.year i.ind i.province if v2==1 ,fe  cluster(id)

xtreg SSCcustomer DIT   $control  i.year i.ind i.province if v2==3 ,fe  cluster(id)
xtreg SSCcustomer DIT   $control  i.year i.ind i.province if v2==2 ,fe  cluster(id)
xtreg SSCcustomer DIT   $control  i.year i.ind i.province if v2==1 ,fe  cluster(id)






*=======================================================================================
	****表5 双重差分法*****
*=======================================================================================
reghdfe SSC didj  if xv==0 ,absorb (year ind province id) vce(r)
reghdfe SSC didj  $control if xv==0 ,absorb (year ind province id) vce(r)


gen  norvar_1 = rnormal()
sort norvar_1

*****截面PSM 
psmatch2 treat  $control, outcome(SSC) logit neighbor(1) ties common ate caliper(0.1)
save psmdata.dta, replace
reghdfe SSC didj  $control if _support == 1&xv==0 ,absorb (year ind province id) vce(r)

*****逐年PSM
**# 2.1 卡尺最近邻匹配（1:2）
forvalue i = 2008/2022{
      preserve
          capture {
              keep if year == `i'
              set seed 0000
              gen  norvar_2 = rnormal()
              sort norvar_2
              psmatch2 treat  $control, outcome(SSC) logit neighbor(1)  ///
                                        ties common ate caliper(0.1)
              save `i'.dta, replace
              }
      restore
      }

clear all

use 2008.dta, clear

forvalue k =2009/2022 {
      capture {
          append using `k'.dta
          }
      }

save ybydata.dta, replace
reghdfe SSC didj  $control if _support == 1&xv==0 ,absorb (year ind province id) vce(r)


*=======================================================================================
	****附图1  平行趋势检验*****
*=======================================================================================
reghdfe SSC eventjt* $control if xv==0 ,absorb (year ind province id) vce(r)

coefplot, baselevels ///
keep(eventjt1 eventjt2 eventjt3 eventjt4 eventjt5 eventjt6 eventjt7 eventjt8 eventjt9 eventjt10 eventjt11 eventjt12 eventjt13 eventjt14 eventjt15 ) ///
vertical ///转置图形
coeflabels(eventjt1=-10 eventjt2=-9   eventjt3=-8 eventjt4=-7 eventjt5=-6 eventjt6=-5 eventjt7=-4 eventjt8=-3 eventjt9=-2 eventjt10=-1 /// 
eventjt11=0 eventjt12=1 eventjt13=2 eventjt14=3  eventjt15=4) /// 
yline(0,lwidth(vthin) lpattern(solid) lcolor(teal)) ///
xline(10,lwidth(vthin) lpattern(solid) lcolor(teal)) ///
ylabel(,labsize(*0.85) angle(0)) xlabel(,labsize(*0.85)) ///
ytitle("Coefficients") ///
msymbol(O) msize(small) mcolor(gs1) ///plot样式
addplot(line @b @at,lcolor(gs1) lwidth(medthick)) ///增加点之间的连线
ciopts(recast(rline) lwidth(thin) lpattern(dash) lcolor(gs2)) ///置信区间样式
graphregion(color(white)) //白底


*=======================================================================================
	****附表2  时间安慰剂检验结果*****
*=======================================================================================

reghdfe SSC did_1  $control if xv==0 ,absorb (year ind province id) vce(r)
reghdfe SSC did_2  $control if xv==0 ,absorb (year ind province id) vce(r)
reghdfe SSC did_3  $control if xv==0 ,absorb (year ind province id) vce(r)
reghdfe SSC did_4  $control if xv==0 ,absorb (year ind province id) vce(r)
reghdfe SSC did_5  $control if xv==0 ,absorb (year ind province id) vce(r)
reghdfe SSC did_6  $control if xv==0 ,absorb (year ind province id) vce(r)
reghdfe SSC did_7  $control if xv==0 ,absorb (year ind province id) vce(r)

*=======================================================================================
	****附图2  个体安慰剂检验*****
*=======================================================================================

global  control   "lp  ROE   GDPsp Ainternet Dual MB Balance  INDEP  SOE "
permute didj beta=_b[didj] se=_se[didj] df_m=e(df_r),reps(500) seed(123) strata(id) saving("anweiji.dta",replace) : reghdfe SSC didj  $control if xv==0 ,absorb (year ind province id) vce(r)
use "anweiji.dta",clear
gen t_value=beta/se
gen p_value=2*ttail(df,abs(beta/se))
twoway (kdensity beta, msymbol(circle_hollow))(scatter p_value beta, yaxis(3)), xline(-0.0221) scheme(s1mono) 


