use "附1-回归数据集.dta",replace
global control lnGDP lnPOP lnSpace Industry lnGovern  lnFinance 
global Chinese `"fontface "宋体": "'
global English `"fontface "times": "'

*************************************************************************************************************
*描述性统计*
*************************************************************************************************************
outreg2 using "描述性统计.doc", replace sum(log) keep(FS digit grain grain_first $control  ) eqkeep(N mean sd min max) sortvar(FS digit gdp grain grain_first  $control ) dec(3)

*************************************************************************************************************
*基准回归*
*************************************************************************************************************
reghdfe FS digit $control ,a( countycode year) vce(cluster countycode)
outreg2 using "表3基准回归.xls",keep(digit $control) sortvar(digit $control) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes) ctitle(FS) replace
reghdfe lnGrain digit $control ,a( countycode year ) vce(cluster countycode)
outreg2 using "表3基准回归.xls",keep(digit $control) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes) ctitle(ln_grain) 
reghdfe lnGrain_First digit $control ,a( countycode year) vce(cluster countycode)
outreg2 using "表3基准回归.xls",keep(digit $control) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes) ctitle(ln_grain_labor)

*动态分析*
reghdfe FS digit digit_1*  $control ,a( countycode year) vce(cluster countycode)
outreg2 using "附录表1.xls",keep(digit*) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes) ctitle(FS) replace
reghdfe lnGrain digit digit_1*  $control ,a( countycode year) vce(cluster countycode)
outreg2 using "附录表1.xls",keep(digit*) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes) ctitle(FS)  
reghdfe lnGrain_First digit digit_1*  $control ,a( countycode year) vce(cluster countycode)
outreg2 using "附录表1.xls",keep(digit*) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes) ctitle(FS) 

*************************************************************************************************************
*稳健性检验*
*************************************************************************************************************
*替换解释变量*
reghdfe FS index $control ,a(countycode year) cluster(countycode)
outreg2 using "附录表2.xls",keep(index) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) replace
reghdfe FS exposure $control ,a(countycode year) cluster(countycode)
outreg2 using "附录表2.xls",keep(exposure) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) 
reghdfe FS digit_pca $control ,a(countycode year) cluster(countycode)
outreg2 using "附录表2.xls",keep(digit_pca) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) 
reghdfe FS digit_ratio $control ,a(countycode year) cluster(countycode)
outreg2 using "附录表2.xls",keep(digit_ratio) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes)

*剔除政策干扰*
reghdfe FS digit ecommerce $control ,a( countycode year) vce(cluster countycode)
outreg2 using "附录表3.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes,Prov_Year Fixed,NO) replace
reghdfe FS digit bigdata $control ,a( countycode year) vce(cluster countycode)
outreg2 using "附录表3.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes,Prov_Year Fixed,NO)
reghdfe FS digit smart $control ,a( countycode year) vce(cluster countycode)
outreg2 using "附录表3.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes,Prov_Year Fixed,NO)
reghdfe FS digit $control ,a(countycode year##prov) cluster(countycode)
outreg2 using "附录表3.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes,Prov_Year Fixed,Yes)

*其他稳健性检验*
*新的粮食安全指数*
reghdfe FS_new digit $control ,a( countycode year ) vce(cluster countycode) 
outreg2 using "附录表4.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) ctitle(FS_new) replace

*控制土地流转*
reghdfe FS digit $control lnland_transfer,a( countycode year ) vce(cluster countycode) 
outreg2 using "附录表4.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) ctitle(land_transfer)

*控制耕地和机械总动能，去除GDP和县域面积
reghdfe FS digit $control lnCultivate lnMar_culti,a( countycode year ) vce(cluster countycode) 
outreg2 using "附录表4.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) ctitle(Add_control)

reghdfe FS digit  Industry lnGovern  lnFinance lnPOP lnCultivate lnMar_culti,a( countycode year ) vce(cluster countycode) 
outreg2 using "附录表4.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) ctitle(change_control)

*粮食生产tfp*
reghdfe tfp digit $control ,a( countycode year ) vce(cluster countycode) 
outreg2 using "附录表4.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) ctitle(tfp)

*动态面板模型GMM估计*
xtset countycode year
reghdfe FS l.FS l(0/1).digit $control ,a( countycode year ) vce(cluster countycode) 
outreg2 using "附录表5.xls",keep(digit l.FS l(0/1).digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) ctitle(ols) replace

xtabond FS l(0/1).digit $control year_* , lags(1) maxldep(2) twostep vce(r)
outreg2 using "附录表5.xls",keep(digit l.FS l(0/1).digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) ctitle(diff_GMM)
xtdpdsys FS l(0/1).digit $control year_* , lags(1) maxldep(2) twostep vce(r) 
outreg2 using "附录表5.xls",keep(digit l.FS l(0/1).digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) ctitle(sys_GMM)

*************************************************************************************************************
*内生性讨论*
*************************************************************************************************************
*工具变量回归-节点距离*
ivreghdfe FS $control (digit=jiedian_year),a( countycode year) cluster(countycode) first savefirst
outreg2 using "表4工具变量回归.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) replace
estimates restore _ivreg2_digit
outreg2 using "表4工具变量回归.xls",keep(jiedian_year) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes)  
ivreghdfe FS $control (digit=broadband_jiedian),a( countycode year) cluster(countycode) first savefirst
outreg2 using "表4工具变量回归.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) 
estimates restore _ivreg2_digit
outreg2 using "表4工具变量回归.xls",keep(broadband_jiedian) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes)  

*工具变量回归-数字经济政策词频*
ivreghdfe FS $control (digit=cipin_digit),a( countycode year) cluster(countycode) first savefirst
outreg2 using "附录表6.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) replace
estimates restore _ivreg2_digit
outreg2 using "附录表6.xls",keep(cipin_digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes)


*宽带中国试点*
reghdfe FS broadband $control ,a(countycode year) vce(cluster countycode )
outreg2 using "附录表6.xls",keep(broadband) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes)

reghdfe FS eventt* $control ,a(countycode year) vce(cluster countycode )
outreg2 using "平行趋势检验.xls",keep(eventt*) se nocons dec(4) aster addtex(Basic Control,YES,Extra Control,YES,City Fixed,YES,Year Fixed,YES) replace
coefplot, baselevels keep(eventt*) vertical yline(0, lcolor(gray) lpattern(dash)) ///
	ylabel(-0.12(0.03)0.06,labsize(*0.75) format(%4.2f) nogrid angle(0)) xlabel(,labsize(*0.75)) ///
	xtitle(`"{$Chinese 时期}"') ///
	ytitle(`"{$Chinese 估}"'`"{$Chinese 计}"'`"{$Chinese 系}"'`"{$Chinese 数}"',orientation(horizontal)) ///
	addplot(line @b @at, lcolor(black)) ///
	levels(95) ///
	ciopts(recast(rcap) lcolor(black)) mcolor(black) ///
	coeflabels( eventt2 = "-4" eventt3 = "-3" eventt4 = "-2" eventt5 = "-1" eventt6 = "0" eventt7 = "1" eventt8 = "2" eventt9 = "3" eventt10 = "4" eventt11 = "5" eventt12 = "6" eventt13 = "7") ///
	graphregion(fc(white))
	graph export "平行趋势检验.png",as(png) replace width(800) height(600)

*安慰剂检验*
preserve
permute broadband beta = _b[broadband],reps(1000) rseed(123)  ///
saving("simulations.dta",replace):reghdfe FS broadband $control ,a(countycode year) vce(cluster countycode )

use "simulations.dta",clear
dpplot beta, color(black*0.8) ///
			 xline(0, lc(gray) lp(dash))	///
             xtitle(`"{$Chinese 估计系数}"') 	///
			 xlabel(-0.01(0.002)0.01, nogrid format(%4.3f) labsize(small)) ///
             ytitle(`"{$Chinese 概}"'`"{$Chinese 率}"'`"{$Chinese 密}"'`"{$Chinese 度}"',orientation(horizontal)) ///
             ylabel(, nogrid format(%4.2f) labsize(small)) ///
             note("") caption("") ///
             graphregion(fcolor(white))
graph export "安慰剂检验.png",as(png) replace width(800) height(600)	

restore

*************************************************************************************************************
*机制分析*
*************************************************************************************************************
reghdfe Relative_income digit $control ,a(countycode year) cluster(countycode)
outreg2 using "表5机制一.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) replace
reghdfe lnCultivate digit $control ,a(countycode year) cluster(countycode)
outreg2 using "表5机制一.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) 
reghdfe lnCrop_sown digit $control ,a(countycode year) cluster(countycode)
outreg2 using "表5机制一.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) 
reghdfe lnGrain_sown digit $control ,a(countycode year) cluster(countycode)
outreg2 using "表5机制一.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) 
reghdfe Culti_utilize  digit  $control  ,a( countycode year ) vce(cluster countycode)
outreg2 using "表5机制一.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) 
reghdfe lnAgri_culti  digit  $control  ,a( countycode year ) vce(cluster countycode)
outreg2 using "表5机制一.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) 

reghdfe Grain_utilize  digit  $control  ,a( countycode year ) vce(cluster countycode) 
outreg2 using "表6机制二.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) replace
reghdfe Grain_productivity  digit  $control  ,a( countycode year ) vce(cluster countycode) 
outreg2 using "表6机制二.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) 
reghdfe lnCoil_cotton_sown  digit  $control  ,a( countycode year ) vce(cluster countycode) 
outreg2 using "表6机制二.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes) 
reghdfe lnGrain_coil_cotton  digit  $control  ,a( countycode year ) vce(cluster countycode)
outreg2 using "表6机制二.xls",keep(digit) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes)

*************************************************************************************************************
*异质性分析*
*************************************************************************************************************
*组件系数差异*
capture program drop bse
program bse, eclass
    *-分组回归
    reghdfe FS digit $control if group==0,a( countycode year )
    scalar b1= _b[digit]
    reghdfe FS digit $control if group==1,a( countycode year )
    scalar b2= _b[digit]

    *-计算组间系数差异
    scalar diff= b1- b2

    *-将组间系数差存储在矩阵中，设置列名方便调取
    matrix b = diff
    matrix colnames b = diff

    *-将组间系数差矩阵返回 e() 中
    ereturn post b
    ereturn display
end

*东中西*
preserve
rename east group
bse
bootstrap _b[diff], reps(500) seed(1234) nowarn : bse
restore
reghdfe FS digit $control if east==1,a( countycode year ) vce(cluster countycode)
outreg2 using "表7异质性一.xls",keep(digit ) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes,SUR chi2,5.86) ctitle(East) replace
reghdfe FS digit $control if east==0 ,a( countycode year ) vce(cluster countycode)
outreg2 using "表7异质性一.xls",keep(digit ) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes,SUR chi2,5.86) ctitle(Middle)

*GDP*
preserve
rename high_gdp group
replace group=group-1
bse
bootstrap _b[diff], reps(500) seed(1234) nowarn : bse
restore
reghdfe FS digit $control if high_gdp==1,a( countycode year ) 
outreg2 using "表7异质性一.xls",keep(digit) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes,SUR chi2,4.67) ctitle(low_pgdp) 
reghdfe FS digit $control if high_gdp==2,a( countycode year ) 
outreg2 using "表7异质性一.xls",keep(digit) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes,SUR chi2,4.67) ctitle(high_pgdp)


*贫困县差异*
preserve
rename poverty_county group
bse
bootstrap _b[diff], reps(500) seed(1234) nowarn : bse
restore
reghdfe FS digit $control if poverty_county==0,a( countycode year ) 
outreg2 using "表7异质性一.xls",keep(digit) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes,SUR chi2,-5.52) ctitle(poverty=0)
reghdfe FS digit $control if poverty_county==1,a( countycode year ) 
outreg2 using "表7异质性一.xls",keep(digit) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes,SUR chi2,-5.52) ctitle(poverty=1)

*耕地*
preserve
rename culti group
replace group=group-1
bse
bootstrap _b[diff], reps(500) seed(1234) nowarn : bse
restore
reghdfe FS digit  $control if culti==1,a( countycode year ) vce(cluster countycode)
outreg2 using "表8异质性二.xls",keep(digit) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes,SUR chi2, 4.16) ctitle(Low_culti) replace 
reghdfe FS digit  $control if culti==2,a( countycode year ) vce(cluster countycode)
outreg2 using "表8异质性二.xls",keep(digit) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes,SUR chi2, 4.16) ctitle(High_culti)


*地形起伏*
preserve
rename dixing group
replace group=group-1
bse
bootstrap _b[diff], reps(500) seed(1234) nowarn : bse
restore
reghdfe FS digit $control if dixing==1,a( countycode year ) 
outreg2 using "表8异质性二.xls",keep(digit) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes,SUR chi2,-8.82) ctitle(fat) 
reghdfe FS digit $control if dixing==2,a( countycode year ) 
outreg2 using "表8异质性二.xls",keep(digit) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes,SUR chi2,-8.82) ctitle(no_fat)

*秦岭淮河*
preserve
rename north group
bse
bootstrap _b[diff], reps(500) seed(1234) nowarn : bse
restore
reghdfe FS digit $control if north==0,a( countycode year ) 
outreg2 using "表8异质性二.xls",keep(digit) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes,SUR chi2,-2.64) ctitle(800mm)
reghdfe FS digit $control if north==1,a( countycode year ) 
outreg2 using "表8异质性二.xls",keep(digit) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes,SUR chi2,-2.64) ctitle(400mm)

*粮食主产区*
preserve
rename GPMA group
bse
bootstrap _b[diff], reps(500) seed(1234) nowarn : bse
restore
reghdfe FS digit $control if GPMA==1,a( countycode year ) vce(cluster countycode) 
outreg2 using "表9异质性三.xls",keep(digit )  se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes,SUR chi2, 7.87) ctitle(GPMA==1) replace
reghdfe FS digit $control if GPMA==0,a( countycode year ) vce(cluster countycode) 
outreg2 using "表9异质性三.xls",keep(digit ) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes,SUR chi2, 7.87) ctitle(GPMA==0)

*种植结构*
preserve
rename main_grain group
bse
bootstrap _b[diff], reps(500) seed(1234) nowarn : bse
restore
reghdfe FS digit $control if main_grain==1,a( countycode year ) vce(cluster countycode) 
outreg2 using "表9异质性三.xls",keep(digit )  se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes,SUR chi2,0.54) ctitle(main_grain==1) 
reghdfe FS digit $control if main_grain==0,a( countycode year ) vce(cluster countycode) 
outreg2 using "表9异质性三.xls",keep(digit ) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes,SUR chi2,0.54) ctitle(main_grain==0)

*复种指数*
preserve
rename count12 group
bse
bootstrap _b[diff], reps(500) seed(1234) nowarn : bse
restore
preserve
rename count23 group
bse
bootstrap _b[diff], reps(500) seed(1234) nowarn : bse
restore

reghdfe FS digit $control if sow_count==1,a( countycode year ) vce(cluster countycode) 
outreg2 using "表10异质性三.xls",keep(digit )  se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes,SUR chi2,3.48) ctitle(sow_count==1) 
reghdfe FS digit $control if sow_count==2,a( countycode year ) vce(cluster countycode) 
outreg2 using "表10异质性三.xls",keep(digit ) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes,SUR chi2,-) ctitle(sow_count==2)
reghdfe FS digit $control if sow_count==3,a( countycode year ) vce(cluster countycode) 
outreg2 using "表10异质性三.xls",keep(digit ) append se nocons dec(4) aster addtex(Basic Control,Yes,County Fixed,Yes,Year Fixed,Yes,SUR chi2,6.10) ctitle(sow_count==3)

*************************************************************************************************************
*异质性补充交互项
reghdfe FS digit digit_east $control ,a( countycode year) vce(cluster countycode)
outreg2 using "附录表7.xls",keep(digit*) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes) replace
reghdfe FS digit digit_gdp $control ,a( countycode year) vce(cluster countycode)
outreg2 using "附录表7.xls",keep(digit*) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes) 
reghdfe FS digit digit_poverty $control ,a( countycode year) vce(cluster countycode)
outreg2 using "附录表7.xls",keep(digit*) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes) 
reghdfe FS digit digit_culti $control ,a( countycode year) vce(cluster countycode)
outreg2 using "附录表7.xls",keep(digit*) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes) 
reghdfe FS digit digit_dixing $control ,a( countycode year) vce(cluster countycode)
outreg2 using "附录表7.xls",keep(digit*) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes) 

reghdfe FS digit digit_north $control ,a( countycode year) vce(cluster countycode)
outreg2 using "附录表8.xls",keep(digit*) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes) replace
reghdfe FS digit digit_GPMA $control ,a( countycode year) vce(cluster countycode)
outreg2 using "附录表8.xls",keep(digit*) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes) 
reghdfe FS digit digit_jiegou $control ,a( countycode year) vce(cluster countycode)
outreg2 using "附录表8.xls",keep(digit*) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes) 
reghdfe FS digit digit_count2 digit_count3 $control ,a( countycode year) vce(cluster countycode)
outreg2 using "附录表8.xls",keep(digit*) append se nocons dec(4) aster addtex(County Fixed,Yes,Year Fixed,Yes) 

*


