close all; clear all; clc
%% 绿色税收、人力资本结构与工资收入差距
% INTRODUCTORY TEXT
%% 参数校准
%1.教育成本参数
min_xlim=0.001;
max_xlim=0.2

a_d=2/3;%最高能力
a_u=4/3;%最低能力
n=0.05;%平均教育成本中产出增加1单位，教育成本增加5%
m=0.07826650;%与工资收入无关的教育成本

%环境污染参数
nv=max_xlim;%污染排放强度
phi=0.3;%污染排放与减排之比对污染存量的弹性数值设为ϕ=0.3
delta=0.9;%自然自我净化率
tau=min_xlim;%绿色税率

%生产函数参数
A=0.5;%技术水平
alpha=0.5;%高技能和低技能劳动的相对重要性
sigmma=1.6;%高技能和低技能劳动力之间的替代弹性
beta=-0.04;%环境污染对高技能劳动者生产效率的影响程度
gamma=-0.08;%环境污染对低技能劳动者生产效率的影响程度
%% 赋值下列参数使得模型退化成基准模型
chi=0;
pho=0.1;
epsilon_l=0;
epsilon_h=0;

%% 绿色税率tau=0.001时的教育流动矩阵
fun = @myfun2; % function
x0 = 0.2; % initial point
options = optimoptions('fsolve','Display','iter');
ssh_0001= fsolve(@(x) myfun2(x,a_d,a_u,n,m,nv,phi,delta,tau,A,sigmma,alpha,beta,gamma),x0,options);
wh=((1-tau).*(A.*(alpha.*(ssh_0001.*((nv./tau).^phi./delta).^beta).^((sigmma-1)./sigmma)+...
    (1-alpha).*((1-ssh_0001).*((nv./tau).^phi./delta).^gamma).^((sigmma-1)./sigmma)).^((sigmma-sigmma+1)./(sigmma-1)))).*...
    alpha.*(ssh_0001.*((nv./tau).^phi./delta).^beta).^((sigmma-1)./sigmma-1).*...
    (((nv./tau).^phi./delta).^beta);%高技能劳动者工资
wl=((1-tau).*(A.*(alpha.*(ssh_0001.*((nv./tau).^phi./delta).^beta).^((sigmma-1)./sigmma)+...
     (1-alpha).*((1-ssh_0001).*((nv./tau).^phi./delta).^gamma).^((sigmma-1)./sigmma)).^((sigmma-sigmma+1)./(sigmma-1)))).*...
    (1-alpha).*((1-ssh_0001).*((nv./tau).^phi./delta).^gamma).^((sigmma-1)./sigmma-1).*...
    (((nv./tau).^phi./delta).^gamma);%低技能劳动者工资
pi_h=((nv./tau).^phi./delta).^(-epsilon_h);%高技能劳动者预期寿命
Y=((1-tau).*(A.*(alpha.*(ssh_0001.*((nv./tau).^phi./delta).^beta).^((sigmma-1)./sigmma)+...
     (1-alpha).*((1-ssh_0001).*((nv./tau).^phi./delta).^gamma).^((sigmma-1)./sigmma)).^(sigmma./(sigmma-1))));

pi_l=((nv./tau).^phi./delta).^(-epsilon_l);%低技能劳动者预期寿命
c=m+n.*Y
P_e_e_0001=((wh- (chi.*((nv./tau).^phi./delta).^pho))./2).*(1-((alpha./(1-alpha)).*((wl./2).^pi_l)./((wh./2).^pi_h)).^2)...
    .*((a_u-a_d).*(m+n.*Y)).^(-1)-(a_d./(a_u-a_d));%父辈接受教育，子代接受教育的概率
P_u_e_0001=((wl- (chi.*((nv./tau).^phi./delta).^pho))./2).*(1-((alpha./(1-alpha)).*((wl./2).^pi_l)./((wh./2).^pi_h)).^2)...
    .*((a_u-a_d).*(m+n.*Y)).^(-1)-(a_d./(a_u-a_d));%父辈没接受教育，子代接受教育的概率
P_e_u_0001=1-P_e_e_0001;%父辈接受教育，子代没接受教育的概率
P_u_u_0001=1-P_u_e_0001;%父辈没接受教育，子代没接受教育的概率

%% 绿色税率tau=0.02时的教育流动矩阵
tau=0.02;
fun = @myfun2; % function
x0 = 0.2; % initial point
options = optimoptions('fsolve','Display','iter');
ssh_002= fsolve(@(x) myfun2(x,a_d,a_u,n,m,nv,phi,delta,tau,A,sigmma,alpha,beta,gamma),x0,options);
wh=((1-tau).*(A.*(alpha.*(ssh_002.*((nv./tau).^phi./delta).^beta).^((sigmma-1)./sigmma)+...
    (1-alpha).*((1-ssh_002).*((nv./tau).^phi./delta).^gamma).^((sigmma-1)./sigmma)).^((sigmma-sigmma+1)./(sigmma-1)))).*...
    alpha.*(ssh_002.*((nv./tau).^phi./delta).^beta).^((sigmma-1)./sigmma-1).*...
    (((nv./tau).^phi./delta).^beta);%高技能劳动者工资

wl=((1-tau).*(A.*(alpha.*(ssh_002.*((nv./tau).^phi./delta).^beta).^((sigmma-1)./sigmma)+...
     (1-alpha).*((1-ssh_002).*((nv./tau).^phi./delta).^gamma).^((sigmma-1)./sigmma)).^((sigmma-sigmma+1)./(sigmma-1)))).*...
    (1-alpha).*((1-ssh_002).*((nv./tau).^phi./delta).^gamma).^((sigmma-1)./sigmma-1).*...
    (((nv./tau).^phi./delta).^gamma);%低技能劳动者工资
pi_h=((nv./tau).^phi./delta).^(-epsilon_h);%高技能劳动者预期寿命
Y=((1-tau).*(A.*(alpha.*(ssh_002.*((nv./tau).^phi./delta).^beta).^((sigmma-1)./sigmma)+...
     (1-alpha).*((1-ssh_002).*((nv./tau).^phi./delta).^gamma).^((sigmma-1)./sigmma)).^(sigmma./(sigmma-1))));
pi_l=((nv./tau).^phi./delta).^(-epsilon_l);%低技能劳动者预期寿命
P_e_e_002=((wh- (chi.*((nv./tau).^phi./delta).^pho))./2).*(1-((alpha./(1-alpha)).*((wl./2).^pi_l)./((wh./2).^pi_h)).^2)...
    .*((a_u-a_d).*(m+n.*Y)).^(-1)-(a_d./(a_u-a_d));%父辈接受教育，子代接受教育的概率
P_u_e_002=((wl- (chi.*((nv./tau).^phi./delta).^pho))./2).*(1-((alpha./(1-alpha)).*((wl./2).^pi_l)./((wh./2).^pi_h)).^2)...
    .*((a_u-a_d).*(m+n.*Y)).^(-1)-(a_d./(a_u-a_d));%父辈没接受教育，子代接受教育的概率
P_e_u_002=1-P_e_e_002;%父辈接受教育，子代没接受教育的概率
P_u_u_002=1-P_u_e_002;%父辈没接受教育，子代没接受教育的概率
%% 绿色税率tau=0.05时的教育流动矩阵
tau=0.05;
fun = @myfun2; % function
x0 = 0.2; % initial point
options = optimoptions('fsolve','Display','iter');
ssh_005= fsolve(@(x) myfun2(x,a_d,a_u,n,m,nv,phi,delta,tau,A,sigmma,alpha,beta,gamma),x0,options);
wh=((1-tau).*(A.*(alpha.*(ssh_005.*((nv./tau).^phi./delta).^beta).^((sigmma-1)./sigmma)+...
    (1-alpha).*((1-ssh_005).*((nv./tau).^phi./delta).^gamma).^((sigmma-1)./sigmma)).^((sigmma-sigmma+1)./(sigmma-1)))).*...
    alpha.*(ssh_005.*((nv./tau).^phi./delta).^beta).^((sigmma-1)./sigmma-1).*...
    (((nv./tau).^phi./delta).^beta);%高技能劳动者工资

wl=((1-tau).*(A.*(alpha.*(ssh_005.*((nv./tau).^phi./delta).^beta).^((sigmma-1)./sigmma)+...
     (1-alpha).*((1-ssh_005).*((nv./tau).^phi./delta).^gamma).^((sigmma-1)./sigmma)).^((sigmma-sigmma+1)./(sigmma-1)))).*...
    (1-alpha).*((1-ssh_005).*((nv./tau).^phi./delta).^gamma).^((sigmma-1)./sigmma-1).*...
    (((nv./tau).^phi./delta).^gamma);%低技能劳动者工资
pi_h=((nv./tau).^phi./delta).^(-epsilon_h);%高技能劳动者预期寿命
Y=((1-tau).*(A.*(alpha.*(ssh_005.*((nv./tau).^phi./delta).^beta).^((sigmma-1)./sigmma)+...
     (1-alpha).*((1-ssh_005).*((nv./tau).^phi./delta).^gamma).^((sigmma-1)./sigmma)).^(sigmma./(sigmma-1))));
pi_l=((nv./tau).^phi./delta).^(-epsilon_l);%低技能劳动者预期寿命
P_e_e_005=((wh- (chi.*((nv./tau).^phi./delta).^pho))./2).*(1-((alpha./(1-alpha)).*((wl./2).^pi_l)./((wh./2).^pi_h)).^2)...
    .*((a_u-a_d).*(m+n.*Y)).^(-1)-(a_d./(a_u-a_d));%父辈接受教育，子代接受教育的概率
P_u_e_005=((wl- (chi.*((nv./tau).^phi./delta).^pho))./2).*(1-((alpha./(1-alpha)).*((wl./2).^pi_l)./((wh./2).^pi_h)).^2)...
    .*((a_u-a_d).*(m+n.*Y)).^(-1)-(a_d./(a_u-a_d));%父辈没接受教育，子代接受教育的概率
P_e_u_005=1-P_e_e_005;%父辈接受教育，子代没接受教育的概率
P_u_u_005=1-P_u_e_005;%父辈没接受教育，子代没接受教育的概率