%%   Figure 4  
close all; clear all; clc
load('date_critical_values');
figure('color',[1 1 1]);
p1=plot(x,e_l,':^k','MarkerIndices',1:60:486,'LineWidth',1.2);hold on
p2=plot(x,e_h,':ok','MarkerIndices',1:60:486,'LineWidth',1.2);hold on
load('date_eduction_cost');
p3=plot(x,C_u,'--k','LineWidth',1);hold on
p4=plot(x,C_d,'-k','LineWidth',1);hold on
x=[0.2578,0.2578];
y=[0,0.1209];
p6=plot(x,y,':k','LineWidth',1);
x=[0.2358,0.2358];
y=[0,0.06022];
p7=plot(x,y,':k','LineWidth',1);
x=[0.273,0.273];
y=[0,0.121];
p7=plot(x,y,':k','LineWidth',1);
text(0.273,0.08,'\leftarrow Steady state')
text(0.1,0.0435,'A^{\prime}');
text(0.2358,0.0435,'B^{\prime}');
text(0.2578,0.0435,'C^{\prime}')
text(0.273,0.0435,'D^{\prime}')
axis([0.1 0.4 0.04 0.15])
legend([p1 p2 p3 p4],'$$\hat{e}^{L}$$','$$\hat{e}^{H}$$',...
    '$$\overline{\mathrm{e}}$$','$$\underline{\mathrm{e}}$$',...
    'interpreter','latex','Location','southoutside','Orientation','horizontal','FontSize',10);
legend("boxoff")
xlabel('$H_{t}$','Interpreter','LaTex','FontName','宋体','FontSize',12,'position',[0.25 0.031]);
ylabel('教育成本','FontName','宋体','FontSize',12,'position',[0.06 0.095]);

set(gcf,'unit','centimeters','position',[10 5 10 8])
set(gca,'Position',[.16 .2 .8 .75]);
print(gcf, '-dtiff', 'figure_4.tif') ;

