close all; clear all; clc
%% 参数校准
%1.教育成本参数
a_d=2/3;%最高能力
a_u=4/3;%最低能力
n=0.05;%平均教育成本中产出增加1单位，教育成本增加5%
m=0.07826650;%平均教育成本中与产出无关的部分

%环境污染参数
nv=0.2;%污染排放强度
phi=0.3;%污染排放与减排之比对污染存量的弹性数值设为ϕ=0.3
delta=0.9;%自然自我净化率

%生产函数参数
A=0.5;%技术水平
alpha=0.5;%高技能和低技能劳动的相对重要性
sigmma=1.6;%高技能和低技能劳动力之间的替代弹性
beta=-0.04;%环境污染对高技能劳动者生产效率的影响程度
gamma=-0.08;%环境污染对低技能劳动者生产效率的影响程度

%% Transtional Dynamics 
figure('color',[1 1 1])
%% 绿色税率tau=0.001
tau=0.001;
p1=fimplicit(@(x,y) myfun_new(x,y,a_d,a_u,n,m,nv,phi,delta,tau,A,sigmma,alpha,beta,gamma),[0.2398 0.25978 0.2398 0.3],'-k','LineWidth',1.5);hold on
p2=fimplicit(@(x,y) myfun(x,y,a_d,a_u,n,m,nv,phi,delta,tau,A,sigmma,alpha,beta,gamma),[0.2598 0.3 0.2398 0.3],'-k','LineWidth',1.5);hold on
x=0.2:0.0001:0.2398;
y=x;
p3=plot(x,y,'-k','LineWidth',1.5);
x=[0.2398,0.2398];
y=[0.2398,0.2561];
p5=plot(x,y,'-k','LineWidth',1.5);

fun = @myfun2; % function
x0 = 0.3; % initial point
options = optimoptions('fsolve','Display','iter');
ssh= fsolve(@(x) myfun2(x,a_d,a_u,n,m,nv,phi,delta,tau,A,sigmma,alpha,beta,gamma),x0,options);
text(ssh+0.001,ssh-0.005,'H^{*}','fontsize',10);
x=[ssh,ssh];
y=[0.2,ssh];
p6=plot(x,y,'-.k','LineWidth',1);

x=[0.2398,0.2398];
y=[0.2,0.2535];
p7=plot(x,y,'-.k','LineWidth',1);

x=[0.2598,0.2598];
y=[0.2,0.2701];
p8=plot(x,y,'-.k','LineWidth',1);

text(0.2,0.205,'O','fontsize',10)
text(0.2358,0.2358,'A','fontsize',10);
text(0.2365,0.2535,'B','fontsize',10);
text(0.256,0.265,'C','fontsize',10)
xlabel('$H_{t}$','Interpreter','LaTex','FontName','宋体','FontSize',12,'position',[0.25 0.19]);
ylabel('$H_{t+1}$','Interpreter','LaTex','FontName','宋体','FontSize',12,'position',[0.19 0.25]);

set(gcf,'unit','centimeters','position',[10 5 10 8])
set(gca,'Position',[.13 .18 .8 .75]);

%% 绿色税率tau=0.02
tau=0.02;
p11=fimplicit(@(x,y) myfun_new(x,y,a_d,a_u,n,m,nv,phi,delta,tau,A,sigmma,alpha,beta,gamma),[0.2232 0.2574 0.2232 0.3],'--k','LineWidth',1.5);hold on
p12=fimplicit(@(x,y) myfun(x,y,a_d,a_u,n,m,nv,phi,delta,tau,A,sigmma,alpha,beta,gamma),[0.2593 0.3 0.2358 0.3],'--k','LineWidth',1.5);hold on
x=[0.2232,0.2232];
y=[0.2232,0.2514];
p13=plot(x,y,'--k','LineWidth',1.5);

text(0.2194,0.2194,'A^{1}','fontsize',10);
text(0.2194,0.2556,'B^{1}','fontsize',10);
text(0.2574,0.2808,'C^{1}','fontsize',10)
text(0.278,0.284,'H^{*1}','fontsize',10)
%% 绿色税率tau=0.05
tau=0.05;
p14=fimplicit(@(x,y) myfun_new(x,y,a_d,a_u,n,m,nv,phi,delta,tau,A,sigmma,alpha,beta,gamma),[0.2292372 0.2574 0.229237 0.3],':k','LineWidth',1.5);hold on
p15=fimplicit(@(x,y) myfun(x,y,a_d,a_u,n,m,nv,phi,delta,tau,A,sigmma,alpha,beta,gamma),[0.256237 0.3 0.2358 0.3],':k','LineWidth',1.5);hold on
x=[0.2292372,0.2292372];
y=[0.2292372,0.2514];
p16=plot(x,y,':k','LineWidth',1.5);
legend([p1 p11,p14],'\tau=0.001','\tau=0.02','\tau=0.05','Location','northwest')
legend('boxoff')

text(0.2398,0.205,'O^{1}','fontsize',10);
text(0.2598,0.205,'O^{2}','fontsize',10);
text(0.2730,0.205,'O^{3}','fontsize',10)
print(gcf, '-dtiff', 'figure_3.tif') ;


