close all; clear all; clc

%% 参数校准
%1.教育成本参数
a_d=2/3;%最高能力
a_u=4/3;%最低能力
n=0.05;%平均教育成本中产出增加1单位，教育成本增加5%
m=0.07826650;%平均教育成本中与产出无关的部分，反向校准所得。

%2.环境污染参数
nv=0.2;%污染排放强度
phi=0.3;%污染排放与减排之比对污染存量的弹性数值设为ϕ=0.3
delta=0.9;%自然自我净化率
tau=0.001;%绿色税率

%3.生产函数参数
A=0.5;%技术水平
alpha=0.5;%高技能和低技能劳动的相对重要性
sigmma=1.6;%高技能和低技能劳动力之间的替代弹性
beta=-0.04;%环境污染对高技能劳动者生产效率的影响程度
gamma=-0.08;%环境污染对低技能劳动者生产效率的影响程度
%% Dynamic Function
fun = @myfun2; % function
x0 = 0.415; % initial point
min_xlim=0.001;
max_xlim=0.08;
options = optimoptions('fsolve','Display','iter');
tau=min_xlim:0.001:max_xlim;%环境税率取值范围
for i=1:1:length(tau);
    tau1=tau(i);
x = fsolve(@(x) myfun2(x,a_d,a_u,n,m,nv,phi,delta,tau1,A,sigmma,alpha,beta,gamma),x0,options);
% %稳态高技能劳动力数量
x1(i)=x(1);
% %稳态环境污染规模
P=((nv./tau1).^phi)./delta;
P1(i)=P(1);
% %工资差距
s_p1(i)=((alpha./(1-alpha)).^(1./sigmma)).*((x(1)./(1-x(1))).^(-1./sigmma))...
    .*P(1).^((beta-gamma).*((sigmma-1)./sigmma));
% % 稳态时产出水平
Y=A.*(alpha.*(x(1).*P(1).^beta).^((sigmma-1)./sigmma)+...
    (1-alpha).*((1-x(1)).*P(1).^gamma).^((sigmma-1)./sigmma)).^(sigmma./(sigmma-1));%均衡时的产出
Y1(i)=(1-tau1).*Y(1);
end

                      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                      %%%%%环境污染与产出水平%%%%%%%%%%
                      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %% figure1:绿色税率、环境污染与产出水平                     
figure('color',[1 1 1])
plot(tau,P1,'-k','LineWidth',1);
xlabel('绿色税率','FontName','宋体','FontSize',11,'FontWeight','bold');
ylabel('环境污染','FontName','宋体','FontSize',11,'FontWeight','bold');
xlim([0 max_xlim]);
set(gcf,'unit','centimeters','position',[10 5 8.5 7])
set(gca,'Position',[.15 .2 .75 .75]);
print(gcf, '-dtiff', 'figure_green.tif') 
hold on
figure('color',[1 1 1])
plot(tau,Y1,'-k','LineWidth',1);
xlabel('绿色税率','FontName','宋体','FontSize',11,'FontWeight','bold');
ylabel('产出水平','FontName','宋体','FontSize',11,'FontWeight','bold');
xlim([0 max_xlim]);
set(gcf,'unit','centimeters','position',[10 5 8.5 7])
set(gca,'Position',[.18 .2 .75 .75]);
print(gcf, '-dtiff', 'figure_production.tif') 
                      %%%%%%%%%%%%%%%%%%%%%%%%%%%
                      %%%工资不平等与劳动力结构%%%%
                      %%%%%%%%%%%%%%%%%%%%%%%%%%%
%% figure1:绿色税率、工资不平等与高技能劳动力数量
figure('color',[1 1 1])
plot(tau,s_p1,'-k','LineWidth',1);
xlabel('绿色税率','FontName','宋体','FontSize',11,'FontWeight','bold');
ylabel('工资不平等','FontName','宋体','FontSize',11,'FontWeight','bold');
xlim([0 max_xlim]);
set(gcf,'unit','centimeters','position',[10 5 8.5 7])
set(gca,'Position',[.18 .2 .75 .75]);
print(gcf, '-dtiff', 'figure_inequality.tif') 
hold on

figure('color',[1 1 1])
plot(tau,x1,'-k','LineWidth',1);
xlabel('绿色税率','FontName','宋体','FontSize',11,'FontWeight','bold');
ylabel('高技能劳动力数量','FontName','宋体','FontSize',11,'FontWeight','bold');
xlim([min_xlim max_xlim]);

set(gcf,'unit','centimeters','position',[10 5 8.5 7])
set(gca,'Position',[.18 .2 .75 .75]);
print(gcf, '-dtiff', 'figure_skill.tif') 
