
use "人力资源.dta",clear
*描述性统计
summarize LE DID age size pci roe cf uis gov hm
global control age size pci roe cf uis gov hm
global fix 证券代码 year 所属城市代码 

*基准回归：
reghdfe LE  DID    ,absorb(证券代码 year)   vce(cluster 证券代码)
reghdfe LE  DID   $control, absorb(证券代码 year)   vce(cluster 证券代码)
reghdfe LE  DID   $control, absorb($fix)   vce(cluster 证券代码)

*稳健性检验：
*替换被解释变量
reghdfe LE2 DID $control,absorb($fix) vce(cluster 证券代码)

*PSM-DID
set seed 10101
gen ranorder=runiform()
sort ranorder
psmatch2 DID $control,outcome(LE) neighbor(4) ate ties logit common
pstest $control, both graph
reghdfe LE DID  $control if _weight!=.,absorb($fix) vce(cluster 证券代码)

*筛选样本
drop if 所属省份代码==110000
drop if 所属省份代码==120000
drop if 所属省份代码==500000
drop if 所属省份代码==310000
drop if hydm==65
drop if hydm==64
drop if hydm==63
drop if hydm==39
reghdfe LE DID $control,absorb($fix) vce(cluster 证券代码)

*预期效应
reghdfe LE DID did2 $control,absorb($fix) vce(cluster 证券代码)

*省份聚类
reghdfe LE DID $control,absorb($fix) vce(cluster 所属省份代码)

*排除其他政策影响
reghdfe LE DID $control zhengce1 zhengce2 zhengce3,absorb($fix) vce(cluster 证券代码)

*异质性分析：
reghdfe LE DID $control if 市场高低==1,absorb($fix) vce(cluster 证券代码)
reghdfe LE DID $control if 配置情况==1,absorb($fix) vce(cluster 证券代码)
reghdfe LE DID $control if 技术水平==1,absorb($fix) vce(cluster 证券代码)

*机制检验：
reghdfe innovation DID,absorb($fix) vce(cluster 证券代码)
reghdfe innovation DID  $control,absorb($fix) vce(cluster 证券代码)

reghdfe information DID, absorb($fix)   vce(cluster 证券代码)
reghdfe information DID $control,absorb($fix) vce(cluster 证券代码)

*调节效应检验：
reghdfe LE DID DIDS S $control,absorb($fix) vce(cluster 证券代码)

*平行趋势检验:
reghdfe LE pre_6 pre_5 pre_4  pre_3 pre_2 dangqi post* $control,absorb($fix) vce(cluster 证券代码)

tsset 证券代码 year
tabulate year, gen(year_dumm)
generate _tintra = 时间差
generate t5=invttail(3436,0.05)
generate b_6=_b[pre_6]
generate se_b_6=_se[pre_6]
generate b_6LB=b_6-t5*se_b_6
generate b_6UB = b_6+t5*se_b_6
generate b_5=_b[pre_5]
generate se_b_5=_se[pre_5]
generate b_5LB=b_5-t5*se_b_5
generate b_5UB=b_5+t5*se_b_5
generate b_4=_b[pre_4]
generate se_b_4=_se[pre_4]
generate b_4LB=b_4-t5*se_b_4
generate b_4UB=b_4+t5*se_b_4
generate b_3=_b[pre_3]
generate se_b_3=_se[pre_3]
generate b_3LB=b_3-t5*se_b_3
generate b_3UB=b_3+t5*se_b_3
generate b_2=_b[pre_2]
generate se_b_2=_se[pre_2]
generate b_2LB=b_2-t5*se_b_2
generate b_2UB=b_2+t5*se_b_2
generate b_0=_b[dangqi]
generate se_b_0=_se[dangqi]
generate b_0LB=b_0-t5*se_b_0
generate b_0UB=b_0+t5*se_b_0
generate b1=_b[post1]
generate se_b1=_se[post1]
generate b1LB=b1-t5*se_b1
generate b1UB=b1+t5*se_b1
generate b2=_b[post2]
generate se_b2=_se[post2]
generate b2LB=b2-t5*se_b2
generate b2UB=b2+t5*se_b2
generate x=(b_6+b_5+b_4+b_3+b_2+b_0)/6
generate b = .
generate LB = .
generate UB = .
replace b = b_6  if _tintra == -6
replace b = b_5  if _tintra == -5
replace b = b_4  if _tintra == -4
replace b = b_3  if _tintra == -3
replace b = b_2  if _tintra == -2
replace b = b_0  if _tintra == 0
replace b = b1   if _tintra == 1
replace b = b2   if _tintra == 2
replace LB = b_6LB if _tintra == -6
replace LB = b_5LB if _tintra == -5
replace LB = b_4LB if _tintra == -4
replace LB = b_3LB if _tintra == -3
replace LB = b_2LB if _tintra == -2
replace LB = b_0LB if _tintra ==0
replace LB = b1LB  if _tintra == 1
replace LB = b2LB  if _tintra == 2
replace UB = b_6UB if _tintra == -6
replace UB = b_5UB if _tintra == -5
replace UB = b_4UB if _tintra == -4
replace UB = b_3UB if _tintra == -3
replace UB = b_2UB if _tintra == -2
replace UB = b_0UB if _tintra == 0
replace UB = b1UB  if _tintra == 1
replace UB = b2UB  if _tintra == 2
replace b=b-x
replace LB=LB-x
replace UB=UB-x
keep _tintra b LB UB
duplicates drop
sort _tintra
twoway (connected b  _tintra, sort lcolor(black) mcolor(black) msymbol(circle_hollow) cmissing(n))(rcap LB UB  _tintra, lcolor(black)lpattern(dash) msize(medium)),ytitle(回归系数  ) ytitle(, size(small))  yline(0, lwidth(vthin) lpattern(dash) lcolor(teal)) ylabel(, labsize(small) angle(horizontal) nogrid) xtitle(政策实施相对时间) xtitle(, size(small)) xline(-1, lwidth(vthin) lpattern(dash) lcolor(teal))  xlabel(-6(1)2, labsize(small))  xmtick(-2(1)2, nolabels ticks)legend(off)graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white))

*安慰剂检验
set matsize 500
mat b = J(500,1,0) 
mat se = J(500,1,0) 
mat p = J(500,1,0)

forvalues i=1/500{
use "人力资源.dta", clear
xtset 证券代码 year  
sample 1,count by(所属城市代码)
sample 190, count   
keep 所属城市代码 year 
rename year policy_year
save match_id.dta, replace   
merge 1:m 所属城市代码 using "人力资源.dta"
xtset 证券代码 year 
gen treatt = (_merge == 3) 
gen period = (year >=policy_year) 
gen didd=treatt*period
reghdfe LE  didd   age  size  pci  roe  cf  uis  gov  hm , absorb(证券代码 year 所属城市代码 )   vce(cluster 证券代码)
mat b[`i',1]=_b[didd]
mat se[`i',1]=_se[didd]
mat p[`i',1]=2*ttail(e(df_r), abs(_b[didd]/_se[didd]))
}


svmat b, names(coef)
svmat se, names(se)
svmat p, names(pvalue)
drop if pvalue1 == .
label var pvalue1 p值
label var coef1 估计系数
keep coef1 se1 pvalue1

twoway (kdensity coef1) (scatter pvalue1 coef1, msymbol(smcircle_hollow) mcolor(blue)), title("Placebo Test") xlabel(-0.1(0.1)0.1) ylabel(,angle(0)) xline(-0.045062, lwidth(vthin) lp(shortdash)) xtitle("Coefficients") yline(0.1,lwidth(vthin) lp(dash)) ytitle(p value) legend(label(1 "kdensity of estimates") label( 2 "p value")) plotregion(style(none)) graphregion(color(white)) 
