clear
cd E:\低碳转型会加剧技能溢价吗?--来自低碳城市试点政策的经验证据
use lowcarbon.dta
xtset id year
sum lsp lsp2 lpgdp trade fdi gov fixed fde lgtfp llpat lgpat hl1 shl2 shl3
global xlist "lpgdp trade fdi gov fixed fde"

*基准回归

reghdfe lsp did , a(id year ) vce(r)
est store m1
reghdfe lsp did $xlist , a(id year ) vce(r)
est store m2
reghdfe lsp2 did , a(id year ) vce(r)
est store m3
reghdfe lsp2 did $xlist , a(id year ) vce(r)
est store m4
reghdfe lsp did2 , a(id year ) vce(r)
est store m5
reghdfe lsp did2 $xlist , a(id year ) vce(r)
est store m6
reg2docx m1 m2 m3 m4 m5 m6 using result.docx,replace  b(%9.4f) se(%9.4f)  scalars(N r2_a(%9.4f)) star(* 0.1 ** 0.05 *** 0.01)


*异质性处理效应检验

bacondecomp lsp did ,ddetail
bacondecomp lsp2 did ,ddetail
bacondecomp lsp did2 ,ddetail


*平行趋势检验
set more off
gen distance = year - t
tab distance, missing
replace distance=-5 if distance<-5
replace distance=5 if distance>5
forvalues i=1/5 { 
gen d_`i' = 0 
replace d_`i' = 1 if treat== 1 & distance== -`i'
}
forvalues i=1/5 { 
gen d`i'  = 0 
replace d`i'  = 1 if treat== 1 & distance== `i'
}
gen current  = 0
replace current = 1 if treat== 1 & distance== 0
reghdfe lsp   d_5 d_4 d_3 d_2 current d1 d2 d3 d4 d5 $xlist , a(id year ) vce(r)

coefplot, baselevels keep( d_5 d_4 d_3 d_2 current d1 d2 d3 d4 d5 ) vertical yline(0) ytitle("回归系数") xtitle("政策实施前/后相对时间") addplot(line @b @at) ciopts(recast(rcap)) scheme(s1mono) levels(95)    coeflabels(  d_5 = "-5" d_4 = "-4" d_3 = "-3" d_2 = "-2" current = "0" d1 = "1" d2 = "2" d3 = "3" d4 = "4" d5 = "5" )


*安慰剂检验 500次
clear
use lowcarbon.dta
xtset id year
global xlist "lpgdp trade fdi gov fixed fde"
forvalue i=1/500{
    sysuse lowcarbon.dta, clear
	xtset id year
    g obs_id= _n 
    gen random_digit= runiform() 
    sort random_digit  
    g random_id= _n 
    preserve
        keep random_id did 
        rename did random_did
        rename random_id idd 
        label var idd 
        save random_did, replace
    restore 
        drop random_digit random_id did 
        rename obs_id idd 
        label var idd 
        save rawdata, replace 
        use rawdata, clear
        merge 1:1 idd using random_did,nogen
        reghdfe lsp random_did $xlist , a(id year ) vce(r)
        g _b_random_did= _b[random_did]  
        g _se_random_did= _se[random_did] 
        keep _b_random_did _se_random_did 
        duplicates drop _b_random_did, force
        save placebo`i', replace  
}
use placebo1, clear
forvalue i=2/500{
    append using placebo`i'
}  
gen tvalue= _b_random_did/ _se_random_did
gen p=2*ttail(e(N)-e(df_m)-1,abs(tvalue))

twoway (scatter p _b_random_did,mcolor(red) yaxis(1) yline(0.1,lwidth(0.3) lp(shortdash))  xlabel(-0.02(0.01)0.02, grid) xtitle(估计系数) ytitle(p值) msymbol(circle) mcolor(black) legend(off)  graphregion(color(white))) (kdensity _b_random_did,mcolor(red) lp(dash) yaxis(2))  


*安慰剂检验 1000次
clear
use lowcarbon.dta
xtset id year
global xlist "lpgdp trade fdi gov fixed fde"
forvalue i=1/1000{
    sysuse lowcarbon.dta, clear
	xtset id year
    g obs_id= _n 
    gen random_digit= runiform() 
    sort random_digit  
    g random_id= _n 
    preserve
        keep random_id did 
        rename did random_did
        rename random_id idd 
        label var idd 
        save random_did, replace
    restore 
        drop random_digit random_id did 
        rename obs_id idd 
        label var idd 
        save rawdata, replace 
        use rawdata, clear
        merge 1:1 idd using random_did,nogen
        reghdfe lsp random_did $xlist , a(id year ) vce(r)
        g _b_random_did= _b[random_did]  
        g _se_random_did= _se[random_did] 
        keep _b_random_did _se_random_did 
        duplicates drop _b_random_did, force
        save placebo`i', replace  
}
use placebo1, clear
forvalue i=2/1000{
    append using placebo`i'
}  
gen tvalue= _b_random_did/ _se_random_did
gen p=2*ttail(e(N)-e(df_m)-1,abs(tvalue))

twoway (scatter p _b_random_did,mcolor(red) yaxis(1) yline(0.1,lwidth(0.3) lp(shortdash))  xlabel(-0.02(0.01)0.02, grid) xtitle(估计系数) ytitle(p值) msymbol(circle) mcolor(black) legend(off)  graphregion(color(white))) (kdensity _b_random_did,mcolor(red) lp(dash) yaxis(2)) 

*psmdid检验
clear
use lowcarbon.dta
xtset id year
global xlist "lpgdp trade fdi gov fixed fde"
set seed 10101
gen ranorder=runiform()
sort ranorder
psmatch2 treat $xlist ,outcome(did) logit n(2)  common caliper(0.05) ties
pstest,both
reghdfe lsp did $xlist , a(id year ) vce(r),if _weight!=.

*其他稳健性检验I
clear
use lowcarbon.dta,clear
xtset id year
global xlist "lpgdp trade fdi gov fixed fde"
gen lspd=log(spd)
gen lspd2=log(spd2)
gen lsp3=log(sp3)
gen lsp4=log(sp4)
gen lspd3=log(spd3)
gen lspd4=log(spd4)

reghdfe lsp did cet $xlist , a(id year ) vce(r)
est store m1
reghdfe lsp did ned $xlist, a(id year ) vce(r)
est store m2
reghdfe lsp did bar $xlist , a(id year ) vce(r)
est store m3
reghdfe lsp did ipc $xlist , a(id year ) vce(r)
est store m4
reghdfe lsp did spc $xlist, a(id year ) vce(r)
est store m5
reg2docx m1 m2 m3 m4 m5  using result.docx,replace  b(%9.4f) se(%9.4f)  scalars(N r2_a(%9.4f)) star(* 0.1 ** 0.05 *** 0.01)


*其他稳健性检验II

reghdfe lsp did $xlist, a(id year#gp ) vce(r) 
est store m1
reghdfe lsp did $xlist, a(id year#emw ) vce(r) 
est store m2
gen tliangkong=liangkong*trend
gen tshenghui=shenghui*trend
gen tzhixia=zhixia*trend
gen ttequ=tequ*trend
reghdfe lsp did tliangkong $xlist , a(id year ) vce(r)
est store m3
reghdfe lsp did tshenghui $xlist , a(id year ) vce(r)
est store m4
reghdfe lsp did tzhixia $xlist , a(id year ) vce(r)
est store m5
reghdfe lsp did ttequ $xlist, a(id year ) vce(r)
est store m6
reg2docx m1 m2 m3 m4 m5 m6 using result.docx,replace  b(%9.4f) se(%9.4f)  scalars(N r2_a(%9.4f)) star(* 0.1 ** 0.05 *** 0.01)



*其他稳健性检验III

reghdfe lspd did $xlist, a(id year ) vce(r)
est store m1
reghdfe lspd2 did  $xlist , a(id year ) vce(r)
est store m2
reghdfe lsp3 did  $xlist , a(id year ) vce(r)
est store m3
reghdfe lsp4 did $xlist , a(id year ) vce(r)
est store m4
reghdfe lspd3 did $xlist, a(id year ) vce(r)
est store m5
reghdfe lspd4 did  $xlist , a(id year ) vce(r)
est store m6
reg2docx m1 m2 m3 m4 m5 m6 using result.docx,replace  b(%9.4f) se(%9.4f)  scalars(N r2_a(%9.4f)) star(* 0.1 ** 0.05 *** 0.01)













